/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.misc.URLBuilder;

public class ReplicatedServersConfig
extends BaseMasterSlaveServersConfig<ReplicatedServersConfig> {
    private List<URL> nodeAddresses = new ArrayList<URL>();
    private int scanInterval = 1000;
    private int database = 0;

    public ReplicatedServersConfig() {
    }

    ReplicatedServersConfig(ReplicatedServersConfig config) {
        super(config);
        this.setNodeAddresses(config.getNodeAddresses());
        this.setScanInterval(config.getScanInterval());
        this.setDatabase(config.getDatabase());
    }

    public ReplicatedServersConfig addNodeAddress(String ... addresses) {
        for (String address : addresses) {
            this.nodeAddresses.add(URLBuilder.create(address));
        }
        return this;
    }

    public List<URL> getNodeAddresses() {
        return this.nodeAddresses;
    }

    void setNodeAddresses(List<URL> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public ReplicatedServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    public ReplicatedServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

