/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.NestedMultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSetMultimapValues<V>
extends RedissonExpirable
implements RSet<V> {
    private static final RedisCommand<ListScanResult<Object>> EVAL_SSCAN = new RedisCommand<Object>("EVAL", new NestedMultiDecoder(new ObjectListReplayDecoder(), new ListScanResultReplayDecoder()), 7, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.OBJECT);
    private static final RedisCommand<Integer> EVAL_SIZE = new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Object>> EVAL_READALL = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), 6, RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Boolean> EVAL_CONTAINS_VALUE = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 6, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE));
    private static final RedisCommand<Boolean> EVAL_CONTAINS_ALL_WITH_VALUES = new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 7, RedisCommand.ValueType.OBJECTS);
    private final RSet<V> set;
    private final Object key;
    private final String timeoutSetName;

    public RedissonSetMultimapValues(Codec codec, CommandAsyncExecutor commandExecutor, String name, String timeoutSetName, Object key) {
        super(codec, commandExecutor, name);
        this.timeoutSetName = timeoutSetName;
        this.key = key;
        this.set = new RedissonSet(codec, commandExecutor, name, null);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return null;
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local res = redis.call('zrem', KEYS[1], ARGV[2]); if res > 0 then redis.call('del', KEYS[2]); end; return res; ", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_SIZE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('scard', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_CONTAINS_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('sismember', KEYS[2], ARGV[3]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    private ListScanResult<ScanObjectEntry> scanIterator(InetSocketAddress client, long startPos) {
        RFuture f = this.commandExecutor.evalReadAsync(client, this.getName(), new ScanCodec(this.codec), EVAL_SSCAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {0, {}};end;return redis.call('sscan', KEYS[2], ARGV[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), startPos, this.key);
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<ScanObjectEntry> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonSetMultimapValues.this.scanIterator(client, nextIterPos);
            }

            @Override
            void remove(V value) {
                RedissonSetMultimapValues.this.remove(value);
            }
        };
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_READALL, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return {};end; return redis.call('smembers', KEYS[2]);", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key);
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public Object[] toArray() {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Set<V> res = this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.set.add(e);
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.set.addAsync(e);
    }

    @Override
    public V removeRandom() {
        return this.set.removeRandom();
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP_SINGLE, this.getName());
    }

    @Override
    public Set<V> removeRandom(int amount) {
        return this.get(this.removeRandomAsync(amount));
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SPOP, this.getName(), amount);
    }

    @Override
    public V random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<V> randomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SRANDMEMBER_SINGLE, this.getName());
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_VALUE, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('srem', KEYS[2], ARGV[3]) > 0 and 1 or 0;", Arrays.asList(this.timeoutSetName, this.getName()), System.currentTimeMillis(), this.key, o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SMOVE, this.getName(), destination, member);
    }

    @Override
    public boolean move(String destination, V member) {
        return this.get(this.moveAsync(destination, member));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local s = redis.call('smembers', KEYS[2]);for i = 1, #s, 1 do for j = 2, #ARGV, 1 do if ARGV[j] == s[i] then table.remove(ARGV, j) end end; end;return #ARGV == 2 and 1 or 0; ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SADD_BOOL, args.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local changed = 0 local s = redis.call('smembers', KEYS[2]) local i = 1 while i <= #s do local element = s[i] local isInAgrs = false for j = 2, #ARGV, 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('SREM', KEYS[2], element) changed = 1 end i = i + 1 end return changed ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 2);
        try {
            byte[] keyState = this.codec.getMapKeyEncoder().encode(this.key);
            args.add(System.currentTimeMillis());
            args.add(keyState);
            args.addAll(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_CONTAINS_ALL_WITH_VALUES, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; local v = 0 for i = 2, #ARGV, 1 do if redis.call('srem', KEYS[2], ARGV[i]) == 1 then v = 1 end end return v ", Arrays.asList(this.timeoutSetName, this.getName()), args.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readUnion(String ... names) {
        return this.get(this.readUnionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SUNION, args.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public int diff(String ... names) {
        return this.get(this.diffAsync(names));
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFFSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readDiff(String ... names) {
        return this.get(this.readDiffAsync(names));
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SDIFF, args.toArray());
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTERSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readIntersection(String ... names) {
        return this.get(this.readIntersectionAsync(names));
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SINTER, args.toArray());
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.set.readSortAsync(order);
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return (Set)this.set.readSort(order);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.set.readSortAsync(order, offset, count);
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return (Set)this.set.readSort(order, offset, count);
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return (Set)this.set.readSort(byPattern, order);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.set.readSortAsync(byPattern, order);
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return (Set)this.set.readSort(byPattern, order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.set.readSortAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSort(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.readSortAsync(byPattern, getPatterns, order);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSort(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.readSortAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.set.sortTo(destName, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.set.sortToAsync(destName, order);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.set.sortTo(destName, byPattern, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.set.sortToAsync(destName, byPattern, order);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, byPattern, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, byPattern, order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.sortTo(destName, byPattern, getPatterns, order);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.set.sortToAsync(destName, byPattern, getPatterns, order);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.sortTo(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.set.sortToAsync(destName, byPattern, getPatterns, order, offset, count);
    }
}

