/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSetCache;
import org.redisson.api.RSetCacheReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;

public class RedissonSetCacheReactive<V>
extends RedissonExpirableReactive
implements RSetCacheReactive<V> {
    private final RedissonSetCache<V> instance;

    public RedissonSetCacheReactive(EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonSetCache(evictionScheduler, (CommandAsyncExecutor)commandExecutor, name);
    }

    public RedissonSetCacheReactive(Codec codec, EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonSetCache(codec, evictionScheduler, commandExecutor, name);
    }

    @Override
    public Publisher<Long> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.ZCARD, this.getName());
    }

    @Override
    public Publisher<Boolean> contains(Object o) {
        return this.reactive(this.instance.containsAsync(o));
    }

    Publisher<ListScanResult<ScanObjectEntry>> scanIterator(InetSocketAddress client, long startPos) {
        return this.reactive(this.instance.scanIteratorAsync(this.getName(), client, startPos));
    }

    @Override
    public Publisher<V> iterator() {
        return new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long nextIterPos) {
                return RedissonSetCacheReactive.this.scanIterator(client, nextIterPos);
            }
        };
    }

    @Override
    public Publisher<Boolean> add(V value, long ttl, TimeUnit unit) {
        return this.reactive(this.instance.addAsync(value, ttl, unit));
    }

    private byte[] encode(V value) throws IOException {
        return this.codec.getValueEncoder().encode(value);
    }

    @Override
    public Publisher<Long> add(V value) {
        try {
            byte[] objectState = this.encode(value);
            long timeoutDate = 92233720368547758L;
            return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); return 1; ", Arrays.asList(this.getName()), System.currentTimeMillis(), timeoutDate, objectState);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Publisher<Boolean> remove(Object o) {
        return this.reactive(this.instance.removeAsync(o));
    }

    @Override
    public Publisher<Boolean> containsAll(Collection<?> c) {
        return this.reactive(this.instance.containsAllAsync(c));
    }

    @Override
    public Publisher<Long> addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceeded(0L);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getName());
        try {
            for (V value : c) {
                byte[] objectState = this.encode(value);
                params.add(score);
                params.add(objectState);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.ZADD_RAW, params.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(Collection<?> c) {
        return this.reactive(this.instance.retainAllAsync(c));
    }

    @Override
    public Publisher<Boolean> removeAll(Collection<?> c) {
        return this.reactive(this.instance.removeAllAsync(c));
    }

    @Override
    public Publisher<Long> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this).addAll(c);
    }
}

