/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.Map;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class StringTemplateParser {
    public static final String DEFAULT_MACRO_PREFIX = "$";
    public static final String DEFAULT_MACRO_START = "${";
    public static final String DEFAULT_MACRO_END = "}";
    protected boolean replaceMissingKey = true;
    protected String missingKeyReplacement;
    protected boolean resolveEscapes = true;
    protected String macroPrefix = "$";
    protected String macroStart = "${";
    protected String macroEnd = "}";
    protected char escapeChar = (char)92;
    protected boolean parseValues;

    public static StringTemplateParser create() {
        return new StringTemplateParser();
    }

    public boolean isReplaceMissingKey() {
        return this.replaceMissingKey;
    }

    public void setReplaceMissingKey(boolean replaceMissingKey) {
        this.replaceMissingKey = replaceMissingKey;
    }

    public String getMissingKeyReplacement() {
        return this.missingKeyReplacement;
    }

    public StringTemplateParser setMissingKeyReplacement(String missingKeyReplacement) {
        this.missingKeyReplacement = missingKeyReplacement;
        return this;
    }

    public boolean isResolveEscapes() {
        return this.resolveEscapes;
    }

    public StringTemplateParser setResolveEscapes(boolean resolveEscapes) {
        this.resolveEscapes = resolveEscapes;
        return this;
    }

    public String getMacroStart() {
        return this.macroStart;
    }

    public StringTemplateParser setMacroStart(String macroStart) {
        this.macroStart = macroStart;
        return this;
    }

    public String getMacroPrefix() {
        return this.macroPrefix;
    }

    public StringTemplateParser setMacroPrefix(String macroPrefix) {
        this.macroPrefix = macroPrefix;
        return this;
    }

    public String getMacroEnd() {
        return this.macroEnd;
    }

    public StringTemplateParser setMacroEnd(String macroEnd) {
        this.macroEnd = macroEnd;
        return this;
    }

    public StringTemplateParser setStrictFormat() {
        this.macroPrefix = null;
        return this;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public StringTemplateParser setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public boolean isParseValues() {
        return this.parseValues;
    }

    public StringTemplateParser setParseValues(boolean parseValues) {
        this.parseValues = parseValues;
        return this;
    }

    public String parse(String template, MacroResolver macroResolver) {
        boolean strict;
        StringBuilder result = new StringBuilder(template.length());
        int i = 0;
        int len = template.length();
        if (this.macroPrefix == null) {
            this.macroPrefix = this.macroStart;
            strict = true;
        } else {
            strict = false;
        }
        int prefixLen = this.macroPrefix.length();
        int startLen = this.macroStart.length();
        int endLen = this.macroEnd.length();
        while (i < len) {
            String value;
            int ndx2;
            int ndx1;
            int ndx = template.indexOf(this.macroPrefix, i);
            if (ndx == -1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == this.escapeChar; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            if (this.resolveEscapes) {
                result.append(template.substring(i, ndx - count));
            } else {
                result.append(template.substring(i, ndx));
            }
            if (escape) {
                result.append(this.macroPrefix);
                i = ndx + prefixLen;
                continue;
            }
            boolean strictFormat = strict;
            if (!strictFormat && StringUtil.isSubstringAt(template, this.macroStart, ndx)) {
                strictFormat = true;
            }
            if (!strictFormat) {
                ndx1 = ndx += prefixLen;
                for (ndx2 = ndx; ndx2 < len && CharUtil.isPropertyNameChar(template.charAt(ndx2)); ++ndx2) {
                }
                if (ndx2 == len) {
                    --ndx2;
                }
                while (ndx2 > ndx && !CharUtil.isAlphaOrDigit(template.charAt(ndx2))) {
                    --ndx2;
                }
                if (++ndx2 == ndx1 + 1) {
                    result.append(this.macroPrefix);
                    i = ndx1;
                    continue;
                }
            } else {
                int n;
                ndx2 = template.indexOf(this.macroEnd, ndx += startLen);
                if (ndx2 == -1) {
                    throw new IllegalArgumentException("Invalid template, unclosed macro at: " + (ndx - startLen));
                }
                ndx1 = ndx;
                while (ndx1 < ndx2 && (n = StringUtil.indexOf(template, this.macroStart, ndx1, ndx2)) != -1) {
                    ndx1 = n + startLen;
                }
            }
            String name = template.substring(ndx1, ndx2);
            if (this.missingKeyReplacement != null || !this.replaceMissingKey) {
                try {
                    value = macroResolver.resolve(name);
                }
                catch (Exception ignore) {
                    value = null;
                }
                if (value == null) {
                    value = this.replaceMissingKey ? this.missingKeyReplacement : template.substring(ndx1 - startLen, ndx2 + 1);
                }
            } else {
                value = macroResolver.resolve(name);
                if (value == null) {
                    value = "";
                }
            }
            if (ndx == ndx1) {
                String stringValue = value.toString();
                if (this.parseValues && stringValue.contains(this.macroStart)) {
                    stringValue = this.parse(stringValue, macroResolver);
                }
                result.append(stringValue);
                i = ndx2;
                if (!strictFormat) continue;
                i += endLen;
                continue;
            }
            template = template.substring(0, ndx1 - startLen) + value.toString() + template.substring(ndx2 + endLen);
            len = template.length();
            i = ndx - startLen;
        }
        return result.toString();
    }

    public static MacroResolver createMapMacroResolver(final Map map) {
        return new MacroResolver(){

            @Override
            public String resolve(String macroName) {
                Object value = map.get(macroName);
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
        };
    }

    public static interface MacroResolver {
        public String resolve(String var1);
    }
}

