/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.PubSubKey;
import org.redisson.client.handler.State;
import org.redisson.client.handler.StateLevel;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListMultiDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.NestedMultiDecoder;
import org.redisson.client.protocol.decoder.SlotsDecoder;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private final Map<String, MultiDecoder<Object>> pubSubMessageDecoders = new HashMap<String, MultiDecoder<Object>>();
    private final Map<PubSubKey, CommandData<Object, Object>> pubSubChannels = PlatformDependent.newConcurrentHashMap();
    private final ExecutorService executor;

    public CommandDecoder(ExecutorService executor) {
        this.executor = executor;
    }

    public void addPubSubCommand(String channel, CommandData<Object, Object> data) {
        String operation = data.getCommand().getName().toLowerCase();
        this.pubSubChannels.put(new PubSubKey(channel, operation), data);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        block16: {
            QueueCommand data = ctx.channel().attr(CommandsQueue.CURRENT_COMMAND).get();
            if (this.log.isTraceEnabled()) {
                this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)in.toString(0, in.writerIndex(), CharsetUtil.UTF_8));
            }
            if (this.state() == null) {
                boolean makeCheckpoint;
                boolean bl = makeCheckpoint = data != null;
                if (data != null) {
                    if (data instanceof CommandsData) {
                        makeCheckpoint = false;
                    } else {
                        CommandData cmd = (CommandData)data;
                        if (cmd.getCommand().getReplayMultiDecoder() != null && (NestedMultiDecoder.class.isAssignableFrom(cmd.getCommand().getReplayMultiDecoder().getClass()) || SlotsDecoder.class.isAssignableFrom(cmd.getCommand().getReplayMultiDecoder().getClass()) || ListMultiDecoder.class.isAssignableFrom(cmd.getCommand().getReplayMultiDecoder().getClass()))) {
                            makeCheckpoint = false;
                        }
                    }
                }
                this.state(new State(makeCheckpoint));
            }
            ((State)this.state()).setDecoderState(null);
            if (data == null) {
                this.decode(in, null, null, ctx.channel());
            } else if (data instanceof CommandData) {
                CommandData cmd = (CommandData)data;
                try {
                    if (((State)this.state()).getLevels().size() > 0) {
                        this.decodeFromCheckpoint(ctx, in, data, cmd);
                        break block16;
                    }
                    this.decode(in, cmd, null, ctx.channel());
                }
                catch (Exception e) {
                    cmd.tryFailure(e);
                }
            } else if (data instanceof CommandsData) {
                CommandsData commands = (CommandsData)data;
                try {
                    this.decodeCommandBatch(ctx, in, data, commands);
                }
                catch (Exception e) {
                    commands.getPromise().tryFailure(e);
                }
                return;
            }
        }
        ctx.pipeline().get(CommandsQueue.class).sendNextCommand(ctx.channel());
        this.state(null);
    }

    private void decodeFromCheckpoint(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandData<Object, Object> cmd) throws IOException {
        StateLevel firstLevel;
        StateLevel secondLevel;
        if (((State)this.state()).getLevels().size() == 2 && (secondLevel = ((State)this.state()).getLevels().get(1)).getParts().isEmpty()) {
            ((State)this.state()).getLevels().remove(1);
        }
        if (((State)this.state()).getLevels().size() == 2) {
            firstLevel = ((State)this.state()).getLevels().get(0);
            StateLevel secondLevel2 = ((State)this.state()).getLevels().get(1);
            this.decodeList(in, cmd, firstLevel.getParts(), ctx.channel(), secondLevel2.getSize(), secondLevel2.getParts());
            Channel channel = ctx.channel();
            MultiDecoder<Object> decoder = this.messageDecoder(cmd, firstLevel.getParts(), channel);
            if (decoder != null) {
                Object result = decoder.decode(firstLevel.getParts(), (State)this.state());
                if (data != null) {
                    this.handleResult(cmd, null, result, true, channel);
                }
            }
        }
        if (((State)this.state()).getLevels().size() == 1) {
            firstLevel = ((State)this.state()).getLevels().get(0);
            if (firstLevel.getParts().isEmpty()) {
                ((State)this.state()).resetLevel();
                this.decode(in, cmd, null, ctx.channel());
            } else {
                this.decodeList(in, cmd, null, ctx.channel(), firstLevel.getSize(), firstLevel.getParts());
            }
        }
    }

    private void decodeCommandBatch(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandsData commandBatch) {
        int i = ((State)this.state()).getBatchIndex();
        RedisException error = null;
        while (in.writerIndex() > in.readerIndex()) {
            CommandData<Object, Object> cmd = null;
            try {
                this.checkpoint();
                ((State)this.state()).setBatchIndex(i);
                cmd = commandBatch.getCommands().get(i);
                this.decode(in, cmd, null, ctx.channel());
                ++i;
            }
            catch (IOException e) {
                cmd.tryFailure(e);
            }
            if (cmd.isSuccess()) continue;
            error = (RedisException)cmd.cause();
        }
        if (commandBatch.isNoResult() || i == commandBatch.getCommands().size()) {
            RPromise<Void> promise = commandBatch.getPromise();
            if (error != null) {
                if (!promise.tryFailure(error) && promise.cause() instanceof RedisTimeoutException) {
                    this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
                }
            } else if (!promise.trySuccess(null) && promise.cause() instanceof RedisTimeoutException) {
                this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
            }
            ctx.pipeline().get(CommandsQueue.class).sendNextCommand(ctx.channel());
            this.state(null);
        } else {
            this.checkpoint();
            ((State)this.state()).setBatchIndex(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String result = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                this.handleResult(data, parts, result, false, channel);
            }
            finally {
                rb.release();
            }
        } else if (code == 45) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String error = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                if (error.startsWith("MOVED")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisMovedException(slot, addr));
                }
                if (error.startsWith("ASK")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisAskException(slot, addr));
                }
                if (error.startsWith("TRYAGAIN")) {
                    data.tryFailure(new RedisTryAgainException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("LOADING")) {
                    data.tryFailure(new RedisLoadingException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("OOM")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (error.contains("-OOM ")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("-OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (data != null) {
                    data.tryFailure(new RedisException(error + ". channel: " + channel + " command: " + data));
                }
                this.log.error("Error: {} channel: {} data: {}", error, channel, data);
            }
            finally {
                rb.release();
            }
        } else if (code == 58) {
            Long result = CommandDecoder.readLong(in);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                Decoder<Object> decoder = this.selectDecoder(data, parts);
                result = decoder.decode(buf, (State)this.state());
            }
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 42) {
            ArrayList<Object> respParts;
            int level = ((State)this.state()).incLevel();
            long size = CommandDecoder.readLong(in);
            if (((State)this.state()).getLevels().size() - 1 >= level) {
                StateLevel stateLevel = ((State)this.state()).getLevels().get(level);
                respParts = stateLevel.getParts();
                size = stateLevel.getSize();
            } else {
                respParts = new ArrayList();
                if (((State)this.state()).isMakeCheckpoint()) {
                    ((State)this.state()).addLevel(new StateLevel(size, respParts));
                }
            }
            this.decodeList(in, data, parts, channel, size, respParts);
        } else {
            String dataStr = in.toString(0, in.writerIndex(), CharsetUtil.UTF_8);
            throw new IllegalStateException("Can't decode replay: " + dataStr);
        }
    }

    private void decodeList(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, long size, List<Object> respParts) throws IOException {
        int i = respParts.size();
        while ((long)i < size) {
            this.decode(in, data, respParts, channel);
            if (((State)this.state()).isMakeCheckpoint()) {
                this.checkpoint();
            }
            ++i;
        }
        MultiDecoder<Object> decoder = this.messageDecoder(data, respParts, channel);
        if (decoder == null) {
            return;
        }
        Object result = decoder.decode(respParts, (State)this.state());
        if (data != null) {
            this.handleResult(data, parts, result, true, channel);
            return;
        }
        if (result instanceof Message) {
            this.checkpoint();
            this.handlePublishSubscribe(data, null, channel, result);
            if (in.writerIndex() > in.readerIndex()) {
                this.decode(in, data, null, channel);
            }
        }
    }

    private void handlePublishSubscribe(CommandData<Object, Object> data, List<Object> parts, Channel channel, final Object result) {
        if (result instanceof PubSubStatusMessage) {
            String channelName = ((PubSubStatusMessage)result).getChannel();
            String operation = ((PubSubStatusMessage)result).getType().name().toLowerCase();
            PubSubKey key = new PubSubKey(channelName, operation);
            CommandData<Object, Object> d = this.pubSubChannels.get(key);
            if (Arrays.asList(RedisCommands.PSUBSCRIBE.getName(), RedisCommands.SUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                this.pubSubChannels.remove(key);
                this.pubSubMessageDecoders.put(channelName, d.getMessageDecoder());
            }
            if (Arrays.asList(RedisCommands.PUNSUBSCRIBE.getName(), RedisCommands.UNSUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                this.pubSubChannels.remove(key);
                this.pubSubMessageDecoders.remove(channelName);
            }
        }
        final RedisPubSubConnection pubSubConnection = (RedisPubSubConnection)RedisPubSubConnection.getFrom(channel);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (result instanceof PubSubStatusMessage) {
                    pubSubConnection.onMessage((PubSubStatusMessage)result);
                } else if (result instanceof PubSubMessage) {
                    pubSubConnection.onMessage((PubSubMessage)result);
                } else {
                    pubSubConnection.onMessage((PubSubPatternMessage)result);
                }
            }
        });
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean multiResult, Channel channel) {
        if (data != null) {
            result = multiResult ? data.getCommand().getConvertor().convertMulti(result) : data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else if (data != null && !data.getPromise().trySuccess(result) && data.cause() instanceof RedisTimeoutException) {
            this.log.warn("response has been skipped due to timeout! channel: {}, command: {}, result: {}", channel, data, result);
        }
    }

    private MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts, Channel channel) {
        if (data == null) {
            if (parts.isEmpty()) {
                return null;
            }
            String command = parts.get(0).toString();
            if (Arrays.asList("subscribe", "psubscribe", "punsubscribe", "unsubscribe").contains(command)) {
                String channelName = parts.get(1).toString();
                PubSubKey key = new PubSubKey(channelName, command);
                CommandData<Object, Object> commandData = this.pubSubChannels.get(key);
                if (commandData == null) {
                    return null;
                }
                return commandData.getCommand().getReplayMultiDecoder();
            }
            if (parts.get(0).equals("message")) {
                String channelName = (String)parts.get(1);
                return this.pubSubMessageDecoders.get(channelName);
            }
            if (parts.get(0).equals("pmessage")) {
                String patternName = (String)parts.get(1);
                return this.pubSubMessageDecoders.get(patternName);
            }
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    private Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        MultiDecoder<Object> multiDecoder;
        if (data == null) {
            if (parts != null) {
                if (parts.size() == 2 && "message".equals(parts.get(0))) {
                    String channelName = (String)parts.get(1);
                    return this.pubSubMessageDecoders.get(channelName);
                }
                if (parts.size() == 3 && "pmessage".equals(parts.get(0))) {
                    String patternName = (String)parts.get(1);
                    return this.pubSubMessageDecoders.get(patternName);
                }
            }
            return StringCodec.INSTANCE.getValueDecoder();
        }
        Decoder<Object> decoder = data.getCommand().getReplayDecoder();
        if (parts != null && (multiDecoder = data.getCommand().getReplayMultiDecoder()).isApplicable(parts.size(), (State)this.state())) {
            decoder = multiDecoder;
        }
        if (decoder == null) {
            decoder = data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP ? (parts.size() % 2 != 0 ? data.getCodec().getMapValueDecoder() : data.getCodec().getMapKeyDecoder()) : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_KEY ? data.getCodec().getMapKeyDecoder() : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_VALUE ? data.getCodec().getMapValueDecoder() : data.getCodec().getValueDecoder()));
        }
        return decoder;
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = CommandDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }
}

