/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.SortOrder;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.codec.ScoredCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonScoredSortedSet<V>
extends RedissonExpirable
implements RScoredSortedSet<V> {
    public RedissonScoredSortedSet(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonScoredSortedSet(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public Collection<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Collection<V>> readAllAsync() {
        return this.valueRangeAsync(0, -1);
    }

    @Override
    public V pollFirst() {
        return this.get(this.pollFirstAsync());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.poll(0);
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.poll(-1);
    }

    private RFuture<V> poll(int index) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('zrange', KEYS[1], ARGV[1], ARGV[2]); if v[1] ~= nil then redis.call('zremrangebyrank', KEYS[1], ARGV[1], ARGV[2]); return v[1]; end return nil;", Collections.singletonList(this.getName()), index, index);
    }

    @Override
    public boolean add(double score, V object) {
        return this.get(this.addAsync(score, object));
    }

    @Override
    public boolean tryAdd(double score, V object) {
        return this.get(this.tryAddAsync(score, object));
    }

    @Override
    public V first() {
        return this.get(this.firstAsync());
    }

    @Override
    public RFuture<V> firstAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getName(), 0, 0);
    }

    @Override
    public V last() {
        return this.get(this.lastAsync());
    }

    @Override
    public RFuture<V> lastAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public RFuture<Boolean> addAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZADD_BOOL, this.getName(), BigDecimal.valueOf(score).toPlainString(), object);
    }

    @Override
    public Long addAll(Map<V, Double> objects) {
        return this.get(this.addAllAsync(objects));
    }

    @Override
    public RFuture<Long> addAllAsync(Map<V, Double> objects) {
        if (objects.isEmpty()) {
            return this.newSucceededFuture(0L);
        }
        ArrayList<Object> params = new ArrayList<Object>(objects.size() * 2 + 1);
        params.add(this.getName());
        try {
            for (Map.Entry<V, Double> entry : objects.entrySet()) {
                params.add(BigDecimal.valueOf(entry.getValue()).toPlainString());
                params.add(this.codec.getValueEncoder().encode(entry.getKey()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZADD, params.toArray());
    }

    @Override
    public RFuture<Boolean> tryAddAsync(double score, V object) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZADD_NX_BOOL, this.getName(), "NX", BigDecimal.valueOf(score).toPlainString(), object);
    }

    @Override
    public boolean remove(Object object) {
        return this.get(this.removeAsync(object));
    }

    @Override
    public int removeRangeByRank(int startIndex, int endIndex) {
        return this.get(this.removeRangeByRankAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Integer> removeRangeByRankAsync(int startIndex, int endIndex) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREMRANGEBYRANK, this.getName(), startIndex, endIndex);
    }

    @Override
    public int removeRangeByScore(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.removeRangeByScoreAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Integer> removeRangeByScoreAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREMRANGEBYSCORE, this.getName(), startValue, endValue);
    }

    private String value(double score, boolean inclusive) {
        StringBuilder element = new StringBuilder();
        if (!inclusive) {
            element.append("(");
        }
        if (Double.isInfinite(score)) {
            element.append(score > 0.0 ? "+inf" : "-inf");
        } else {
            element.append(BigDecimal.valueOf(score).toPlainString());
        }
        return element.toString();
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public RFuture<Boolean> removeAsync(Object object) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREM, this.getName(), object);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZCARD_INT, this.getName());
    }

    @Override
    public boolean contains(Object object) {
        return this.get(this.containsAsync(object));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZSCORE_CONTAINS, this.getName(), o);
    }

    @Override
    public Double getScore(V o) {
        return this.get(this.getScoreAsync(o));
    }

    @Override
    public RFuture<Double> getScoreAsync(V o) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)new ScoredCodec(this.codec), RedisCommands.ZSCORE, this.getName(), o);
    }

    @Override
    public Integer rank(V o) {
        return this.get(this.rankAsync(o));
    }

    @Override
    public RFuture<Integer> rankAsync(V o) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANK_INT, this.getName(), o);
    }

    private ListScanResult<ScanObjectEntry> scanIterator(InetSocketAddress client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, this.getName(), (Codec)new ScanCodec(this.codec), RedisCommands.ZSCAN, this.getName(), startPos);
        return (ListScanResult)this.get(f);
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<ScanObjectEntry> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonScoredSortedSet.this.scanIterator(client, nextIterPos);
            }

            @Override
            void remove(V value) {
                RedissonScoredSortedSet.this.remove(value);
            }
        };
    }

    @Override
    public Object[] toArray() {
        List res = (List)this.get(this.valueRangeAsync(0, -1));
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List res = (List)this.get(this.valueRangeAsync(0, -1));
        return res.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(true);
        }
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, RedisCommand.ValueType.OBJECTS), "for j = 1, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore == false then return 0;end; end; return 1; ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> params = new ArrayList<String>(c.size() + 1);
        params.add(this.getName());
        params.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2);
        for (Object object : c) {
            params.add(0);
            params.add(this.encode(object));
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], 2, KEYS[1], KEYS[2], 'aggregate', 'sum');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getName(), "redisson_temp__{" + this.getName() + "}"), params.toArray());
    }

    @Override
    public Double addScore(V object, Number value) {
        return this.get(this.addScoreAsync(object, value));
    }

    @Override
    public RFuture<Double> addScoreAsync(V object, Number value) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)DoubleCodec.INSTANCE, RedisCommands.ZINCRBY, this.getName(), new BigDecimal(value.toString()).toPlainString(), this.encode(object));
    }

    @Override
    public Collection<V> valueRange(int startIndex, int endIndex) {
        return this.get(this.valueRangeAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGE, this.getName(), startIndex, endIndex);
    }

    @Override
    public Collection<V> valueRangeReversed(int startIndex, int endIndex) {
        return this.get(this.valueRangeReversedAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANGE, this.getName(), startIndex, endIndex);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(int startIndex, int endIndex) {
        return this.get(this.entryRangeAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGE_ENTRY, this.getName(), startIndex, endIndex, "WITHSCORES");
    }

    @Override
    public Collection<ScoredEntry<V>> entryRangeReversed(int startIndex, int endIndex) {
        return this.get(this.entryRangeReversedAsync(startIndex, endIndex));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(int startIndex, int endIndex) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANGE_ENTRY, this.getName(), startIndex, endIndex, "WITHSCORES");
    }

    @Override
    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getName(), startValue, endValue);
    }

    @Override
    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANGEBYSCORE, this.getName(), endValue, startValue);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getName(), startValue, endValue, "WITHSCORES");
    }

    @Override
    public Collection<V> valueRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<V>> valueRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_LIST, this.getName(), startValue, endValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<V> valueRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<V>> valueRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANGEBYSCORE, this.getName(), endValue, startValue, "LIMIT", offset, count);
    }

    @Override
    public Collection<ScoredEntry<V>> entryRange(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public Collection<ScoredEntry<V>> entryRangeReversed(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        return this.get(this.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count));
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZRANGEBYSCORE_ENTRY, this.getName(), startValue, endValue, "WITHSCORES", "LIMIT", offset, count);
    }

    @Override
    public RFuture<Collection<ScoredEntry<V>>> entryRangeReversedAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive, int offset, int count) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANGEBYSCORE_ENTRY, this.getName(), endValue, startValue, "WITHSCORES", "LIMIT", offset, count);
    }

    @Override
    public RFuture<Integer> revRankAsync(V o) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZREVRANK_INT, this.getName(), o);
    }

    @Override
    public Integer revRank(V o) {
        return this.get(this.revRankAsync(o));
    }

    @Override
    public Long count(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        return this.get(this.countAsync(startScore, startScoreInclusive, endScore, endScoreInclusive));
    }

    @Override
    public RFuture<Long> countAsync(double startScore, boolean startScoreInclusive, double endScore, boolean endScoreInclusive) {
        String startValue = this.value(startScore, startScoreInclusive);
        String endValue = this.value(endScore, endScoreInclusive);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZCOUNT, this.getName(), startValue, endValue);
    }

    @Override
    public int intersection(String ... names) {
        return this.get(this.intersectionAsync(names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        return this.intersectionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public int intersection(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.intersectionAsync(aggregate, names));
    }

    @Override
    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(this.getName());
        args.add(names.length);
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZINTERSTORE_INT, args.toArray());
    }

    @Override
    public int intersection(Map<String, Double> nameWithWeight) {
        return this.get(this.intersectionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Integer> intersectionAsync(Map<String, Double> nameWithWeight) {
        return this.intersectionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public int intersection(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.intersectionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Integer> intersectionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(this.getName());
        args.add(nameWithWeight.size());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZINTERSTORE_INT, args.toArray());
    }

    @Override
    public int union(String ... names) {
        return this.get(this.unionAsync(names));
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        return this.unionAsync(RScoredSortedSet.Aggregate.SUM, names);
    }

    @Override
    public int union(RScoredSortedSet.Aggregate aggregate, String ... names) {
        return this.get(this.unionAsync(aggregate, names));
    }

    @Override
    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, String ... names) {
        ArrayList<Object> args = new ArrayList<Object>(names.length + 4);
        args.add(this.getName());
        args.add(names.length);
        args.addAll(Arrays.asList(names));
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZUNIONSTORE_INT, args.toArray());
    }

    @Override
    public int union(Map<String, Double> nameWithWeight) {
        return this.get(this.unionAsync(nameWithWeight));
    }

    @Override
    public RFuture<Integer> unionAsync(Map<String, Double> nameWithWeight) {
        return this.unionAsync(RScoredSortedSet.Aggregate.SUM, nameWithWeight);
    }

    @Override
    public int union(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        return this.get(this.unionAsync(aggregate, nameWithWeight));
    }

    @Override
    public RFuture<Integer> unionAsync(RScoredSortedSet.Aggregate aggregate, Map<String, Double> nameWithWeight) {
        ArrayList<Object> args = new ArrayList<Object>(nameWithWeight.size() * 2 + 5);
        args.add(this.getName());
        args.add(nameWithWeight.size());
        args.addAll(nameWithWeight.keySet());
        args.add("WEIGHTS");
        ArrayList<String> weights = new ArrayList<String>();
        for (Double weight : nameWithWeight.values()) {
            weights.add(BigDecimal.valueOf(weight).toPlainString());
        }
        args.addAll(weights);
        args.add("AGGREGATE");
        args.add(aggregate.name());
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.ZUNIONSTORE_INT, args.toArray());
    }

    @Override
    public Set<V> readSort(SortOrder order) {
        return this.get(this.readSortAsync(order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), order});
    }

    @Override
    public Set<V> readSort(SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "LIMIT", offset, count, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, order));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "BY", byPattern, order});
    }

    @Override
    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, order, offset, count));
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, new Object[]{this.getName(), "BY", byPattern, "LIMIT", offset, count, order});
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.readSortAsync(byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SORT_SET, params.toArray());
    }

    @Override
    public int sortTo(String destName, SortOrder order) {
        return this.get(this.sortToAsync(destName, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        return this.sortToAsync(destName, null, Collections.<String>emptyList(), order, -1, -1);
    }

    @Override
    public int sortTo(String destName, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, null, Collections.<String>emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, order, offset, count));
    }

    @Override
    public int sortTo(String destName, String byPattern, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        return this.sortToAsync(destName, byPattern, Collections.<String>emptyList(), order, -1, -1);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        return this.sortToAsync(destName, byPattern, Collections.<String>emptyList(), order, offset, count);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        return this.sortToAsync(destName, byPattern, getPatterns, order, -1, -1);
    }

    @Override
    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.get(this.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        if (byPattern != null) {
            params.add("BY");
            params.add(byPattern);
        }
        if (offset != -1 && count != -1) {
            params.add("LIMIT");
        }
        if (offset != -1) {
            params.add(offset);
        }
        if (count != -1) {
            params.add(count);
        }
        for (String pattern : getPatterns) {
            params.add("GET");
            params.add(pattern);
        }
        params.add((Object)order);
        params.add("STORE");
        params.add(destName);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SORT_TO, params.toArray());
    }
}

