/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.filter;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.fn.timer.Timer;
import reactor.rx.action.Action;

public class SkipUntilTimeout<T>
extends Action<T, T> {
    private final long time;
    private final TimeUnit unit;
    private final Timer timer;
    private volatile boolean started = false;

    public SkipUntilTimeout(long time, TimeUnit unit, Timer timer) {
        this.unit = unit;
        this.timer = timer;
        this.time = time;
    }

    @Override
    protected void doNext(T ev) {
        if (this.started) {
            this.broadcastNext(ev);
        }
    }

    @Override
    protected void doOnSubscribe(Subscription subscription) {
        this.timer.submit(new Consumer<Long>(){

            @Override
            public void accept(Long aLong) {
                SkipUntilTimeout.this.started = true;
            }
        }, this.time, this.unit);
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "time=" + this.time + "unit=" + (Object)((Object)this.unit) + '}';
    }
}

