/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.error;

import reactor.fn.Function;
import reactor.rx.action.Action;

public final class ErrorReturnAction<T, E extends Throwable>
extends Action<T, T> {
    private final Function<? super E, ? extends T> function;
    private final Class<E> selector;

    public ErrorReturnAction(Class<E> selector, Function<? super E, ? extends T> function) {
        this.function = function;
        this.selector = selector;
    }

    @Override
    protected void doNext(T ev) {
        this.broadcastNext(ev);
    }

    @Override
    protected void doError(Throwable cause) {
        if (this.selector.isAssignableFrom(cause.getClass())) {
            this.broadcastNext(this.function.apply(cause));
            this.broadcastComplete();
        } else {
            super.doError(cause);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "{" + "catch-type=" + this.selector + '}';
    }
}

