/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.utility.RandomString;

public interface NamingStrategy {
    public String subclass(TypeDescription.Generic var1);

    public String redefine(TypeDescription var1);

    public String rebase(TypeDescription var1);

    public static class PrefixingRandom
    extends AbstractBase {
        private final String prefix;
        private final RandomString randomString;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            return String.format("%s.%s$%s", this.prefix, superClass.getName(), this.randomString.nextString());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((PrefixingRandom)other).prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public String toString() {
            return "NamingStrategy.PrefixingRandom{prefix='" + this.prefix + '\'' + ", randomString=" + this.randomString + '}';
        }
    }

    public static class SuffixingRandom
    extends AbstractBase {
        public static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        public static final String NO_PREFIX = "";
        private static final String JAVA_PACKAGE = "java.";
        private final String suffix;
        private final String javaLangPackagePrefix;
        private final RandomString randomString;
        private final BaseNameResolver baseNameResolver;

        public SuffixingRandom(String suffix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver) {
            this(suffix, baseNameResolver, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.baseNameResolver = baseNameResolver;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.randomString = new RandomString();
        }

        @Override
        protected String name(TypeDescription superClass) {
            String baseName = this.baseNameResolver.resolve(superClass);
            if (baseName.startsWith(JAVA_PACKAGE) && !this.javaLangPackagePrefix.equals(NO_PREFIX)) {
                baseName = this.javaLangPackagePrefix + "." + baseName;
            }
            return String.format("%s$%s$%s", baseName, this.suffix, this.randomString.nextString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SuffixingRandom that = (SuffixingRandom)other;
            return this.javaLangPackagePrefix.equals(that.javaLangPackagePrefix) && this.suffix.equals(that.suffix) && this.baseNameResolver.equals(that.baseNameResolver);
        }

        public int hashCode() {
            int result = this.suffix.hashCode();
            result = 31 * result + this.javaLangPackagePrefix.hashCode();
            result = 31 * result + this.baseNameResolver.hashCode();
            return result;
        }

        public String toString() {
            return "NamingStrategy.SuffixingRandom{suffix='" + this.suffix + '\'' + ", javaLangPackagePrefix='" + this.javaLangPackagePrefix + '\'' + ", baseNameResolver=" + this.baseNameResolver + ", randomString=" + this.randomString + '}';
        }

        public static interface BaseNameResolver {
            public String resolve(TypeDescription var1);

            public static class ForFixedValue
            implements BaseNameResolver {
                private final String name;

                public ForFixedValue(String name) {
                    this.name = name;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.name;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((ForFixedValue)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue{name='" + this.name + '\'' + '}';
                }
            }

            public static class ForGivenType
            implements BaseNameResolver {
                private final TypeDescription typeDescription;

                public ForGivenType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public String resolve(TypeDescription typeDescription) {
                    return this.typeDescription.getName();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForGivenType)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForGivenType{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static enum ForUnnamedType implements BaseNameResolver
            {
                INSTANCE;


                @Override
                public String resolve(TypeDescription typeDescription) {
                    return typeDescription.getName();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForUnnamedType." + this.name();
                }
            }
        }
    }

    public static abstract class AbstractBase
    implements NamingStrategy {
        @Override
        public String subclass(TypeDescription.Generic superClass) {
            return this.name(superClass.asErasure());
        }

        protected abstract String name(TypeDescription var1);

        @Override
        public String redefine(TypeDescription typeDescription) {
            return typeDescription.getName();
        }

        @Override
        public String rebase(TypeDescription typeDescription) {
            return typeDescription.getName();
        }
    }
}

