/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.ThreadLocalRandom;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.redisson.RedissonMap;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.ObjectMapEntryReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.Cache;
import org.redisson.misc.Hash;
import org.redisson.misc.LFUCacheMap;
import org.redisson.misc.LRUCacheMap;
import org.redisson.misc.NoneCacheMap;
import org.redisson.misc.RPromise;

public class RedissonLocalCachedMap<K, V>
extends RedissonMap<K, V>
implements RLocalCachedMap<K, V> {
    private static final RedisCommand<Set<Object>> ALL_KEYS = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Map.Entry<Object, Object>>> ALL_ENTRIES = new RedisCommand<Set<Map.Entry<Object, Object>>>("EVAL", new ObjectMapEntryReplayDecoder(), RedisCommand.ValueType.MAP);
    private static final RedisCommand<Object> EVAL_PUT = new RedisCommand("EVAL", -1, RedisCommand.ValueType.OBJECT, RedisCommand.ValueType.MAP_VALUE);
    private static final RedisCommand<Object> EVAL_REMOVE = new RedisCommand("EVAL", -1, RedisCommand.ValueType.OBJECT, RedisCommand.ValueType.MAP_VALUE);
    private byte[] id;
    private RTopic<Object> invalidationTopic;
    private Cache<CacheKey, CacheValue> cache;
    private int invalidateEntryOnChange;
    private int invalidationListenerId;

    protected RedissonLocalCachedMap(RedissonClient redisson, CommandAsyncExecutor commandExecutor, String name, LocalCachedMapOptions options) {
        super(commandExecutor, name);
        this.init(redisson, name, options);
    }

    protected RedissonLocalCachedMap(RedissonClient redisson, Codec codec, CommandAsyncExecutor connectionManager, String name, LocalCachedMapOptions options) {
        super(codec, connectionManager, name);
        this.init(redisson, name, options);
    }

    private void init(RedissonClient redisson, String name, LocalCachedMapOptions options) {
        this.id = this.generateId();
        if (options.isInvalidateEntryOnChange()) {
            this.invalidateEntryOnChange = 1;
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.NONE) {
            this.cache = new NoneCacheMap<CacheKey, CacheValue>(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LRU) {
            this.cache = new LRUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LFU) {
            this.cache = new LFUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        this.invalidationTopic = redisson.getTopic(name + ":topic");
        if (options.isInvalidateEntryOnChange()) {
            this.invalidationListenerId = this.invalidationTopic.addListener(new MessageListener<Object>(){

                @Override
                public void onMessage(String channel, Object msg) {
                    LocalCachedMapInvalidate invalidateMsg;
                    if (msg instanceof LocalCachedMapClear) {
                        RedissonLocalCachedMap.this.cache.clear();
                    }
                    if (msg instanceof LocalCachedMapInvalidate && !Arrays.equals((invalidateMsg = (LocalCachedMapInvalidate)msg).getExcludedId(), RedissonLocalCachedMap.this.id)) {
                        CacheKey key = new CacheKey(invalidateMsg.getKeyHash());
                        RedissonLocalCachedMap.this.cache.remove(key);
                    }
                }
            });
        }
    }

    private CacheKey toCacheKey(Object key) {
        byte[] encoded = this.encodeMapKey(key);
        return this.toCacheKey(encoded);
    }

    private CacheKey toCacheKey(byte[] encodedKey) {
        return new CacheKey(Hash.hash(encodedKey));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        CacheKey cacheKey = this.toCacheKey(key);
        if (!this.cache.containsKey(cacheKey)) {
            return super.containsKeyAsync(key);
        }
        return this.newSucceededFuture(true);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        CacheValue cacheValue = new CacheValue(null, value);
        if (!this.cache.containsValue(cacheValue)) {
            return super.containsValueAsync(value);
        }
        return this.newSucceededFuture(true);
    }

    @Override
    public RFuture<V> getAsync(final Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        final CacheKey cacheKey = this.toCacheKey(key);
        CacheValue cacheValue = (CacheValue)this.cache.get(cacheKey);
        if (cacheValue != null && cacheValue.getValue() != null) {
            return this.newSucceededFuture(cacheValue.getValue());
        }
        RFuture future = super.getAsync(key);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    protected byte[] generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return id;
    }

    @Override
    public RFuture<V> putAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        byte[] mapKey = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(mapKey);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        CacheValue cacheValue = new CacheValue(key, value);
        this.cache.put(cacheKey, cacheValue);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_PUT, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 and ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end; return v; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), mapKey, this.encodeMapValue(value), msg, this.invalidateEntryOnChange);
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        byte[] encodedKey = this.encodeMapKey(key);
        byte[] encodedValue = this.encodeMapKey(value);
        CacheKey cacheKey = this.toCacheKey(encodedKey);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        CacheValue cacheValue = new CacheValue(key, value);
        this.cache.put(cacheKey, cacheValue);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 then if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;return 0; end; return 1; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), encodedKey, encodedValue, msg, this.invalidateEntryOnChange);
    }

    @Override
    public void destroy() {
        if (this.invalidationListenerId != 0) {
            this.invalidationTopic.removeListener(this.invalidationListenerId);
        }
    }

    @Override
    public RFuture<V> removeAsync(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        byte[] keyEncoded = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyEncoded);
        byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        this.cache.remove(cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, EVAL_REMOVE, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hdel', KEYS[1], ARGV[1]) == 1 and ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[2]); end; return v", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), keyEncoded, msgEncoded, this.invalidateEntryOnChange);
    }

    @Override
    public RFuture<Long> fastRemoveAsync(K ... keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.invalidateEntryOnChange);
        for (K k : keys) {
            byte[] keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
            if (this.invalidateEntryOnChange == 1) {
                byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
                params.add(msgEncoded);
                continue;
            }
            params.add(null);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 2, #ARGV, 2 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then if ARGV[1] == '1' then redis.call('publish', KEYS[2], ARGV[j+1]); end; counter = counter + 1;end;end;return counter;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), params.toArray());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<CacheKey, CacheValue> cacheMap = new HashMap<CacheKey, CacheValue>(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            CacheKey cacheKey = this.toCacheKey(entry.getKey());
            CacheValue cacheValue = new CacheValue(entry.getKey(), entry.getValue());
            cacheMap.put(cacheKey, cacheValue);
        }
        this.cache.putAll(cacheMap);
        super.putAll(m);
        if (this.invalidateEntryOnChange == 1) {
            for (CacheKey cacheKey : cacheMap.keySet()) {
                this.invalidationTopic.publish(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
            }
        }
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.cache.clear();
        byte[] msgEncoded = this.encode(new LocalCachedMapClear());
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1]) == 1 and ARGV[2] == '1' then redis.call('publish', KEYS[2], ARGV[1]); return 1;end; return 0;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), msgEncoded, this.invalidateEntryOnChange);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private Iterator<Map.Entry<K, V>> cacheEntrySetIterator() {
        final Iterator iter = this.cache.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new AbstractMap.SimpleEntry<Object, Object>(((CacheValue)entry.getValue()).getKey(), ((CacheValue)entry.getValue()).getValue());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    private Iterator<K> cacheKeySetIterator() {
        final Iterator iter = this.cache.values().iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public K next() {
                CacheValue value = (CacheValue)iter.next();
                return value.getKey();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        final HashMap result = new HashMap();
        HashSet<K> mapKeys = new HashSet<K>(keys);
        Iterator iterator = mapKeys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            CacheValue value = (CacheValue)this.cache.get(key);
            if (value == null) continue;
            result.put(key, value.getValue());
            iterator.remove();
        }
        final RPromise<Map<K, V>> promise = this.newPromise();
        RFuture future = super.getAllAsync(mapKeys);
        future.addListener(new FutureListener<Map<K, V>>(){

            @Override
            public void operationComplete(Future<Map<K, V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Map map = future.getNow();
                result.putAll(map);
                RedissonLocalCachedMap.this.cacheMap(map);
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    private void cacheMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            byte[] mapKey = this.encodeMapKey(entry.getKey());
            CacheKey cacheKey = this.toCacheKey(mapKey);
            CacheValue cacheValue = new CacheValue(entry.getKey(), entry.getValue());
            this.cache.put(cacheKey, cacheValue);
        }
    }

    @Override
    public RFuture<Void> putAllAsync(final Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return this.newSucceededFuture(null);
        }
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 3);
        ArrayList<byte[]> msgs = new ArrayList<byte[]>(map.size());
        params.add(this.invalidateEntryOnChange);
        params.add(map.size() * 2);
        for (Map.Entry<K, V> t : map.entrySet()) {
            byte[] mapKey = this.encodeMapKey(t.getKey());
            byte[] mapValue = this.encodeMapValue(t.getValue());
            params.add(mapKey);
            params.add(mapValue);
            CacheKey cacheKey = this.toCacheKey(mapKey);
            byte[] msgEncoded = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
            msgs.add(msgEncoded);
        }
        params.addAll(msgs);
        RFuture<Void> future = this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('hmset', KEYS[1], unpack(ARGV, 3, tonumber(ARGV[2]) + 2));if ARGV[1] == '1' then for i = tonumber(ARGV[2]) + 3, #ARGV, 1 do redis.call('publish', KEYS[2], ARGV[i]); end; end;", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), params.toArray());
        future.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                RedissonLocalCachedMap.this.cacheMap(map);
            }
        });
        return future;
    }

    @Override
    public RFuture<V> addAndGetAsync(final K key, Number value) {
        final byte[] keyState = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        RFuture future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("EVAL", new NumberConvertor(value.getClass())), "local result = redis.call('HINCRBYFLOAT', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end; return result; ", Arrays.asList(this.getName(), this.invalidationTopic.getChannelNames().get(0)), keyState, new BigDecimal(value.toString()).toPlainString(), this.invalidateEntryOnChange, msg);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(keyState);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(final K key, final V value) {
        RFuture<Boolean> future = super.fastPutIfAbsentAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        final ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<byte[]> mapKeys = new ArrayList<byte[]>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(value.getValue());
        }
        final RPromise<Collection<V>> promise = this.newPromise();
        RFuture future = this.commandExecutor.evalReadAsync(this.getName(), this.codec, ALL_KEYS, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 == 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
        future.addListener(new FutureListener<Collection<V>>(){

            @Override
            public void operationComplete(Future<Collection<V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                result.addAll((Collection)future.get());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        final HashSet<AbstractMap.SimpleEntry<Object, Object>> result = new HashSet<AbstractMap.SimpleEntry<Object, Object>>();
        ArrayList<byte[]> mapKeys = new ArrayList<byte[]>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(new AbstractMap.SimpleEntry<Object, Object>(value.getKey(), value.getValue()));
        }
        final RPromise<Set<Map.Entry<K, V>>> promise = this.newPromise();
        RFuture future = this.commandExecutor.evalReadAsync(this.getName(), this.codec, ALL_ENTRIES, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 == 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j]);table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
        future.addListener(new FutureListener<Set<Map.Entry<K, V>>>(){

            @Override
            public void operationComplete(Future<Set<Map.Entry<K, V>>> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                for (Map.Entry entry : future.getNow()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(entry.getKey(), entry.getValue()));
                }
                result.addAll(future.getNow());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public RFuture<V> replaceAsync(final K key, final V value) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        RFuture future = this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end; return v; else return nil; end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0)), keyState, valueState, this.invalidateEntryOnChange, msg);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() != null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Boolean> replaceAsync(final K key, V oldValue, final V newValue) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] oldValueState = this.encodeMapValue(oldValue);
        byte[] newValueState = this.encodeMapValue(newValue);
        final CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[5]); end; return 1; else return 0; end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0)), keyState, oldValueState, newValueState, this.invalidateEntryOnChange, msg);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, newValue));
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        byte[] valueState = this.encodeMapValue(value);
        final CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] msg = this.encode(new LocalCachedMapInvalidate(this.id, cacheKey.getKeyHash()));
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end; return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Arrays.asList(this.getName(key), this.invalidationTopic.getChannelNames().get(0)), keyState, valueState, this.invalidateEntryOnChange, msg);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cache.remove(cacheKey);
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<V> putIfAbsentAsync(final K key, final V value) {
        RFuture<V> future = super.putIfAbsentAsync(key, value);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() == null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cache.put(cacheKey, new CacheValue(key, value));
                }
            }
        });
        return future;
    }

    abstract class CompositeIterable<T>
    implements Iterator<T> {
        private T currentObject;
        private Iterator<T> cacheIterator;
        private Iterator<T> mapIterator;

        public CompositeIterable(Iterator<T> cacheIterator, Iterator<T> mapIterator) {
            this.cacheIterator = cacheIterator;
            this.mapIterator = mapIterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.cacheIterator.hasNext()) {
                while (this.mapIterator.hasNext()) {
                    this.currentObject = this.mapIterator.next();
                    if (this.isCacheContains(this.currentObject)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        abstract boolean isCacheContains(T var1);

        @Override
        public T next() {
            if (this.currentObject != null) {
                T val = this.currentObject;
                this.currentObject = null;
                return val;
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cacheIterator.next();
        }

        @Override
        public void remove() {
            if (this.currentObject != null) {
                this.mapIterator.remove();
                this.currentObject = null;
                return;
            }
            this.cacheIterator.remove();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new CompositeIterable<Map.Entry<K, V>>(RedissonLocalCachedMap.this.cacheEntrySetIterator(), RedissonLocalCachedMap.super.entrySet().iterator()){

                @Override
                boolean isCacheContains(Map.Entry<K, V> entry) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    return RedissonLocalCachedMap.this.cache.containsKey(cacheKey);
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = RedissonLocalCachedMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return RedissonLocalCachedMap.super.remove(key, value);
            }
            return false;
        }

        @Override
        public final int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public final void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iter = RedissonLocalCachedMap.this.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)iter.next()).getValue();
                }

                @Override
                public void remove() {
                    iter.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonLocalCachedMap.this.containsValue(o);
        }

        @Override
        public int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new CompositeIterable<K>(RedissonLocalCachedMap.this.cacheKeySetIterator(), RedissonLocalCachedMap.super.keySet().iterator()){

                @Override
                boolean isCacheContains(Object object) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(object);
                    return RedissonLocalCachedMap.this.cache.containsKey(cacheKey);
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return RedissonLocalCachedMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RedissonLocalCachedMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return RedissonLocalCachedMap.this.size();
        }

        @Override
        public void clear() {
            RedissonLocalCachedMap.this.clear();
        }
    }

    public static class CacheValue {
        private final Object key;
        private final Object value;

        public CacheValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheValue other = (CacheValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "CacheValue [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static class CacheKey {
        private final byte[] keyHash;

        public CacheKey(byte[] keyHash) {
            this.keyHash = keyHash;
        }

        public byte[] getKeyHash() {
            return this.keyHash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.keyHash);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Arrays.equals(this.keyHash, other.keyHash);
        }

        public String toString() {
            return "CacheKey [keyHash=" + Arrays.toString(this.keyHash) + "]";
        }
    }

    public static class LocalCachedMapInvalidate {
        private byte[] excludedId;
        private byte[] keyHash;

        public LocalCachedMapInvalidate() {
        }

        public LocalCachedMapInvalidate(byte[] excludedId, byte[] keyHash) {
            this.keyHash = keyHash;
            this.excludedId = excludedId;
        }

        public byte[] getExcludedId() {
            return this.excludedId;
        }

        public byte[] getKeyHash() {
            return this.keyHash;
        }
    }

    public static class LocalCachedMapClear {
    }
}

