/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;

public class AsyncSemaphore {
    private int counter;
    private final Queue<Runnable> listeners = new LinkedList<Runnable>();

    public AsyncSemaphore(int permits) {
        this.counter = permits;
    }

    public void acquireUninterruptibly() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.acquire(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Runnable listener) {
        boolean run = false;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            if (this.counter == 0) {
                this.listeners.add(listener);
                return;
            }
            if (this.counter > 0) {
                --this.counter;
                run = true;
            }
        }
        if (run) {
            listener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable listener) {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Runnable runnable = null;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            ++this.counter;
            runnable = this.listeners.poll();
        }
        if (runnable != null) {
            this.acquire(runnable);
        }
    }
}

