/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonDeque;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonQueue;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonStream;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RAtomicDoubleReactive;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.api.RBatchReactive;
import org.redisson.api.RBitSetReactive;
import org.redisson.api.RBlockingDequeReactive;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RDequeReactive;
import org.redisson.api.RFuture;
import org.redisson.api.RGeoReactive;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.api.RKeysReactive;
import org.redisson.api.RLexSortedSetReactive;
import org.redisson.api.RListMultimapReactive;
import org.redisson.api.RListReactive;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RQueueReactive;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.api.RScriptReactive;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetMultimapReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.RStreamReactive;
import org.redisson.api.RTopicReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.CommandReactiveBatchService;
import org.redisson.reactive.ReactiveProxyBuilder;
import org.redisson.reactive.RedissonKeysReactive;
import org.redisson.reactive.RedissonLexSortedSetReactive;
import org.redisson.reactive.RedissonListMultimapReactive;
import org.redisson.reactive.RedissonListReactive;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonScoredSortedSetReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetMultimapReactive;
import org.redisson.reactive.RedissonSetReactive;
import reactor.fn.Supplier;

public class RedissonBatchReactive
implements RBatchReactive {
    private final EvictionScheduler evictionScheduler;
    private final CommandReactiveBatchService executorService;
    private final BatchOptions options;

    public RedissonBatchReactive(EvictionScheduler evictionScheduler, ConnectionManager connectionManager, BatchOptions options) {
        this.evictionScheduler = evictionScheduler;
        this.executorService = new CommandReactiveBatchService(connectionManager);
        this.options = options;
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonStream(this.executorService, name), RStreamReactive.class);
    }

    @Override
    public <K, V> RStreamReactive<K, V> getStream(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonStream(codec, this.executorService, name), RStreamReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBucket(this.executorService, name), RBucketReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBucket(codec, this.executorService, name), RBucketReactive.class);
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonHyperLogLog(this.executorService, name), RHyperLogLogReactive.class);
    }

    @Override
    public <V> RHyperLogLogReactive<V> getHyperLogLog(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonHyperLogLog(codec, this.executorService, name), RHyperLogLogReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonList(this.executorService, name, null), new RedissonListReactive(this.executorService, name), RListReactive.class);
    }

    @Override
    public <V> RListReactive<V> getList(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonList(codec, this.executorService, name, null), new RedissonListReactive(codec, this.executorService, name), RListReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.executorService, name, null, null);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapReactive(map, null), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.executorService, name, null, null);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapReactive(map, null), RMapReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.executorService, name, null, null);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.executorService, name, null, null);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.executorService, name, null);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetReactive(set, null), RSetReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.executorService, name, null);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetReactive(set, null), RSetReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonTopic(this.executorService, name), RTopicReactive.class);
    }

    @Override
    public RTopicReactive getTopic(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonTopic(codec, this.executorService, name), RTopicReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonQueue(this.executorService, name, null), new RedissonListReactive(this.executorService, name), RQueueReactive.class);
    }

    @Override
    public <V> RQueueReactive<V> getQueue(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonQueue(codec, this.executorService, name, null), new RedissonListReactive(codec, this.executorService, name), RQueueReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBlockingQueue(this.executorService, name, null), new RedissonListReactive(this.executorService, name), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RBlockingQueueReactive<V> getBlockingQueue(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBlockingQueue(codec, this.executorService, name, null), new RedissonListReactive(codec, this.executorService, name), RBlockingQueueReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonDeque(this.executorService, name, null), new RedissonListReactive(this.executorService, name), RDequeReactive.class);
    }

    @Override
    public <V> RDequeReactive<V> getDeque(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonDeque(codec, this.executorService, name, null), new RedissonListReactive(codec, this.executorService, name), RDequeReactive.class);
    }

    @Override
    public RAtomicLongReactive getAtomicLong(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonAtomicLong(this.executorService, name), RAtomicLongReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.executorService, name, null);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetCacheReactive(set, null), RSetCacheReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.executorService, name, null);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetCacheReactive(set, null), RSetCacheReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonScoredSortedSet(this.executorService, name, null), new RedissonScoredSortedSetReactive(this.executorService, name), RScoredSortedSetReactive.class);
    }

    @Override
    public <V> RScoredSortedSetReactive<V> getScoredSortedSet(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonScoredSortedSet(codec, this.executorService, name, null), new RedissonScoredSortedSetReactive(codec, this.executorService, name), RScoredSortedSetReactive.class);
    }

    @Override
    public RLexSortedSetReactive getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.executorService, name, null);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonLexSortedSetReactive(set), RLexSortedSetReactive.class);
    }

    @Override
    public RBitSetReactive getBitSet(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBitSet(this.executorService, name), RBitSetReactive.class);
    }

    @Override
    public RScriptReactive getScript() {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonScript(this.executorService), RScriptReactive.class);
    }

    @Override
    public RScriptReactive getScript(Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonScript(this.executorService, codec), RScriptReactive.class);
    }

    @Override
    public RKeysReactive getKeys() {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonKeys(this.executorService), new RedissonKeysReactive(this.executorService), RKeysReactive.class);
    }

    @Override
    public Publisher<BatchResult<?>> execute() {
        return this.executorService.superReactive(new Supplier<RFuture<BatchResult<?>>>(){

            @Override
            public RFuture<BatchResult<?>> get() {
                return RedissonBatchReactive.this.executorService.executeAsync(RedissonBatchReactive.this.options);
            }
        });
    }

    @Override
    public RBatchReactive atomic() {
        this.options.atomic();
        return this;
    }

    @Override
    public RBatchReactive syncSlaves(int slaves, long timeout, TimeUnit unit) {
        this.options.syncSlaves(slaves, timeout, unit);
        return this;
    }

    @Override
    public RBatchReactive skipResult() {
        this.options.skipResult();
        return this;
    }

    @Override
    public RBatchReactive retryAttempts(int retryAttempts) {
        this.options.retryAttempts(retryAttempts);
        return this;
    }

    @Override
    public RBatchReactive retryInterval(long retryInterval, TimeUnit unit) {
        this.options.retryInterval(retryInterval, unit);
        return this;
    }

    @Override
    public RBatchReactive timeout(long timeout, TimeUnit unit) {
        this.options.responseTimeout(timeout, unit);
        return this;
    }

    public void enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        this.executorService.enableRedissonReferenceSupport(redissonReactive);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonGeo(this.executorService, name, null), new RedissonScoredSortedSetReactive(this.executorService, name), RGeoReactive.class);
    }

    @Override
    public <V> RGeoReactive<V> getGeo(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonGeo(codec, this.executorService, name, null), new RedissonScoredSortedSetReactive(codec, this.executorService, name), RGeoReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonSetMultimap(this.executorService, name), new RedissonSetMultimapReactive(this.executorService, name, null), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RSetMultimapReactive<K, V> getSetMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonSetMultimap(codec, this.executorService, name), new RedissonSetMultimapReactive(codec, this.executorService, name, null), RSetMultimapReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonListMultimap(this.executorService, name), new RedissonListMultimapReactive(this.executorService, name), RListMultimapReactive.class);
    }

    @Override
    public <K, V> RListMultimapReactive<K, V> getListMultimap(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonListMultimap(codec, this.executorService, name), new RedissonListMultimapReactive(codec, this.executorService, name), RListMultimapReactive.class);
    }

    @Override
    public RAtomicDoubleReactive getAtomicDouble(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonAtomicDouble(this.executorService, name), RAtomicDoubleReactive.class);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBlockingDeque(this.executorService, name, null), new RedissonListReactive(this.executorService, name), RBlockingDequeReactive.class);
    }

    @Override
    public <V> RBlockingDequeReactive<V> getBlockingDeque(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, new RedissonBlockingDeque(codec, this.executorService, name, null), new RedissonListReactive(codec, this.executorService, name), RBlockingDequeReactive.class);
    }
}

