/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import org.redisson.misc.HighwayHash;

public class Hash {
    private static final long[] KEY = new long[]{-7046029254386353131L, -892627106017720268L, 1189556596181725777L, -545944830069338475L};

    private Hash() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash128toArray(ByteBuf objectState) {
        long[] hash = Hash.hash128(objectState);
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(16);
        try {
            buf.writeLong(hash[0]).writeLong(hash[1]);
            byte[] dst = new byte[buf.readableBytes()];
            buf.readBytes(dst);
            byte[] byArray = dst;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    public static long hash64(ByteBuf objectState) {
        HighwayHash h = Hash.calcHash(objectState);
        return h.finalize64();
    }

    public static long[] hash128(ByteBuf objectState) {
        HighwayHash h = Hash.calcHash(objectState);
        return h.finalize128();
    }

    protected static HighwayHash calcHash(ByteBuf objectState) {
        HighwayHash h = new HighwayHash(KEY);
        int length = objectState.readableBytes();
        int offset = objectState.readerIndex();
        byte[] data = new byte[32];
        int i = 0;
        while (i + 32 <= length) {
            objectState.getBytes(offset + i, data);
            h.updatePacket(data, 0);
            i += 32;
        }
        if ((length & 0x1F) != 0) {
            data = new byte[length & 0x1F];
            objectState.getBytes(offset + i, data);
            h.updateRemainder(data, 0, length & 0x1F);
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash128toBase64(ByteBuf objectState) {
        long[] hash = Hash.hash128(objectState);
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(16);
        try {
            String string;
            buf.writeLong(hash[0]).writeLong(hash[1]);
            ByteBuf b = Base64.encode(buf);
            try {
                String s = b.toString(CharsetUtil.UTF_8);
                string = s.substring(0, s.length() - 2);
            }
            catch (Throwable throwable) {
                b.release();
                throw throwable;
            }
            b.release();
            return string;
        }
        finally {
            buf.release();
        }
    }
}

