/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisOutOfMemoryException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.State;
import org.redisson.client.handler.StateLevel;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char ZERO = '0';
    ThreadLocal<List<CommandData<?, ?>>> commandsData = new ThreadLocal();

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        QueueCommand data = ctx.channel().attr(CommandsQueue.CURRENT_COMMAND).get();
        if (this.log.isTraceEnabled()) {
            this.log.trace("reply: {}, channel: {}, command: {}", in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), ctx.channel(), data);
        }
        if (this.state() == null) {
            boolean makeCheckpoint = false;
            this.state(new State(makeCheckpoint));
        }
        ((State)this.state()).setDecoderState(null);
        this.decodeCommand(ctx, in, data);
    }

    protected void sendNext(ChannelHandlerContext ctx, QueueCommand data) {
        if (data != null) {
            if (data.isExecuted()) {
                this.sendNext(ctx);
            }
        } else {
            this.sendNext(ctx);
        }
    }

    protected void decodeCommand(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data) throws Exception {
        if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                if (((State)this.state()).isMakeCheckpoint()) {
                    this.decodeFromCheckpoint(ctx, in, data, cmd);
                } else {
                    this.decode(in, cmd, null, ctx, false);
                }
                this.sendNext(ctx, data);
            }
            catch (Exception e) {
                this.log.error("Unable to decode data. reply: {}, channel: {}, command: {}", in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), ctx.channel(), data, e);
                cmd.tryFailure(e);
                this.sendNext(ctx);
                throw e;
            }
        }
        if (data instanceof CommandsData) {
            CommandsData commands = (CommandsData)data;
            try {
                this.decodeCommandBatch(ctx, in, data, commands);
            }
            catch (Exception e) {
                commands.getPromise().tryFailure(e);
                this.sendNext(ctx);
                throw e;
            }
        }
        try {
            while (in.writerIndex() > in.readerIndex()) {
                this.decode(in, null, null, ctx, false);
            }
            this.sendNext(ctx);
        }
        catch (Exception e) {
            this.log.error("Unable to decode data. channel: {} message: {}", ctx.channel(), in.toString(0, in.writerIndex(), CharsetUtil.UTF_8), e);
            this.sendNext(ctx);
            throw e;
        }
    }

    protected void sendNext(ChannelHandlerContext ctx) {
        ctx.pipeline().get(CommandsQueue.class).sendNextCommand(ctx.channel());
        this.state(null);
    }

    protected void decodeFromCheckpoint(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandData<Object, Object> cmd) throws IOException {
        StateLevel level = ((State)this.state()).getLastLevel();
        List<Object> prevParts = null;
        if (((State)this.state()).getLevels().size() > 1) {
            StateLevel prevLevel = ((State)this.state()).getLevels().get(((State)this.state()).getLevel() - 1);
            prevParts = prevLevel.getParts();
        }
        this.decodeList(in, cmd, prevParts, ctx, level.getSize(), level.getParts(), false);
        if (((State)this.state()).getLastLevel() == level) {
            ((State)this.state()).removeLastLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeCommandBatch(ChannelHandlerContext ctx, ByteBuf in, QueueCommand data, CommandsData commandBatch) throws Exception {
        int i = ((State)this.state()).getBatchIndex();
        Throwable error = null;
        while (in.writerIndex() > in.readerIndex()) {
            CommandData<Object, Object> commandData;
            block23: {
                commandData = null;
                try {
                    this.checkpoint();
                    ((State)this.state()).setBatchIndex(i);
                    RedisCommand<?> cmd = commandBatch.getCommands().get(i).getCommand();
                    boolean skipConvertor = commandBatch.isQueued();
                    if (!commandBatch.isAtomic() || RedisCommands.EXEC.getName().equals(cmd.getName()) || RedisCommands.WAIT.getName().equals(cmd.getName())) {
                        commandData = commandBatch.getCommands().get(i);
                        if (RedisCommands.EXEC.getName().equals(cmd.getName())) {
                            skipConvertor = false;
                            if (commandBatch.getAttachedCommands() != null) {
                                this.commandsData.set(commandBatch.getAttachedCommands());
                            } else {
                                this.commandsData.set(commandBatch.getCommands());
                            }
                        }
                    }
                    try {
                        this.decode(in, commandData, null, ctx, skipConvertor);
                    }
                    finally {
                        if (commandData != null && RedisCommands.EXEC.getName().equals(commandData.getCommand().getName())) {
                            this.commandsData.remove();
                        }
                    }
                    if (commandData == null || !RedisCommands.EXEC.getName().equals(commandData.getCommand().getName()) || !commandData.getPromise().isSuccess()) break block23;
                    List objects = (List)commandData.getPromise().getNow();
                    Iterator iter = objects.iterator();
                    boolean multiFound = false;
                    for (CommandData<Object, Object> commandData2 : commandBatch.getCommands()) {
                        if (multiFound) {
                            if (!iter.hasNext()) break;
                            Object res = iter.next();
                            this.completeResponse(commandData2, res, ctx.channel());
                        }
                        if (!RedisCommands.MULTI.getName().equals(commandData2.getCommand().getName())) continue;
                        multiFound = true;
                    }
                }
                catch (Exception e) {
                    if (commandData != null) {
                        commandData.tryFailure(e);
                    }
                    throw e;
                }
            }
            ++i;
            if (commandData == null || commandData.isSuccess()) continue;
            error = commandData.cause();
        }
        if (commandBatch.isSkipResult() || i == commandBatch.getCommands().size()) {
            RPromise<Void> promise = commandBatch.getPromise();
            if (error != null) {
                if (!promise.tryFailure(error) && promise.cause() instanceof RedisTimeoutException) {
                    this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
                }
            } else if (!promise.trySuccess(null) && promise.cause() instanceof RedisTimeoutException) {
                this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)LogHelper.toString(data));
            }
            this.sendNext(ctx);
        } else {
            this.checkpoint();
            ((State)this.state()).setBatchIndex(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, ChannelHandlerContext ctx, boolean skipConvertor) throws IOException {
        byte code = in.readByte();
        Channel channel = ctx.channel();
        if (code == 43) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String result = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                this.handleResult(data, parts, result, skipConvertor, channel);
            }
            finally {
                rb.release();
            }
        } else if (code == 45) {
            ByteBuf rb = in.readBytes(in.bytesBefore((byte)13));
            try {
                String error = rb.toString(CharsetUtil.UTF_8);
                in.skipBytes(2);
                if (error.startsWith("MOVED")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisMovedException(slot, addr));
                }
                if (error.startsWith("ASK")) {
                    String[] errorParts = error.split(" ");
                    int slot = Integer.valueOf(errorParts[1]);
                    String addr = errorParts[2];
                    data.tryFailure(new RedisAskException(slot, addr));
                }
                if (error.startsWith("TRYAGAIN")) {
                    data.tryFailure(new RedisTryAgainException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("LOADING")) {
                    data.tryFailure(new RedisLoadingException(error + ". channel: " + channel + " data: " + data));
                }
                if (error.startsWith("OOM")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (error.contains("-OOM ")) {
                    data.tryFailure(new RedisOutOfMemoryException(error.split("-OOM ")[1] + ". channel: " + channel + " data: " + data));
                }
                if (data != null) {
                    data.tryFailure(new RedisException(error + ". channel: " + channel + " command: " + LogHelper.toString(data)));
                }
                this.log.error("Error message from Redis: {} channel: {}", (Object)error, (Object)channel);
            }
            finally {
                rb.release();
            }
        } else if (code == 58) {
            Long result = CommandDecoder.readLong(in);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                Decoder<Object> decoder = this.selectDecoder(data, parts);
                result = decoder.decode(buf, (State)this.state());
            }
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 42) {
            long size = CommandDecoder.readLong(in);
            ArrayList<Object> respParts = new ArrayList<Object>(Math.max((int)size, 0));
            StateLevel lastLevel = null;
            if (((State)this.state()).isMakeCheckpoint()) {
                lastLevel = new StateLevel(size, respParts);
                ((State)this.state()).addLevel(lastLevel);
            }
            ((State)this.state()).incLevel();
            this.decodeList(in, data, parts, ctx, size, respParts, skipConvertor);
            ((State)this.state()).decLevel();
            if (((State)this.state()).isMakeCheckpoint() && lastLevel == ((State)this.state()).getLastLevel() && lastLevel.isFull()) {
                ((State)this.state()).removeLastLevel();
            }
        } else {
            String dataStr = in.toString(0, in.writerIndex(), CharsetUtil.UTF_8);
            throw new IllegalStateException("Can't decode replay: " + dataStr);
        }
    }

    private void decodeList(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, ChannelHandlerContext ctx, long size, List<Object> respParts, boolean skipConvertor) throws IOException {
        MultiDecoder<Object> decoder;
        if (parts == null && this.commandsData.get() != null) {
            List<CommandData<?, ?>> commands = this.commandsData.get();
            int i = respParts.size();
            while ((long)i < size) {
                int suffix = 0;
                if (RedisCommands.MULTI.getName().equals(commands.get(0).getCommand().getName())) {
                    suffix = 1;
                }
                CommandData<Object, Object> commandData = commands.get(i + suffix);
                this.decode(in, commandData, respParts, ctx, skipConvertor);
                if (commandData.getPromise().isDone() && !commandData.getPromise().isSuccess()) {
                    data.tryFailure(commandData.cause());
                }
                if (((State)this.state()).isMakeCheckpoint()) {
                    this.checkpoint();
                }
                ++i;
            }
        } else {
            int i = respParts.size();
            while ((long)i < size) {
                this.decode(in, data, respParts, ctx, skipConvertor);
                if (((State)this.state()).isMakeCheckpoint()) {
                    this.checkpoint();
                }
                ++i;
            }
        }
        if ((decoder = this.messageDecoder(data, respParts)) == null) {
            return;
        }
        Object result = decoder.decode(respParts, (State)this.state());
        this.decodeResult(data, parts, ctx, result);
    }

    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, ChannelHandlerContext ctx, Object result) throws IOException {
        if (data != null) {
            this.handleResult(data, parts, result, true, ctx.channel());
        }
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean skipConvertor, Channel channel) {
        if (data != null && !skipConvertor) {
            result = data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else {
            this.completeResponse(data, result, channel);
        }
    }

    protected void completeResponse(CommandData<Object, Object> data, Object result, Channel channel) {
        if (data != null && !data.getPromise().trySuccess(result) && data.cause() instanceof RedisTimeoutException) {
            this.log.warn("response has been skipped due to timeout! channel: {}, command: {}, result: {}", channel, LogHelper.toString(data), LogHelper.toString(result));
        }
    }

    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null && parts.isEmpty()) {
            return null;
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        Decoder<Object> mDecoder;
        MultiDecoder<Object> multiDecoder;
        if (data == null) {
            return StringCodec.INSTANCE.getValueDecoder();
        }
        if (parts != null && (multiDecoder = data.getCommand().getReplayMultiDecoder()) != null && (mDecoder = multiDecoder.getDecoder(parts.size(), (State)this.state())) != null) {
            return mDecoder;
        }
        Decoder<Object> decoder = data.getCommand().getReplayDecoder();
        if (decoder == null) {
            if (data.getCodec() == null) {
                return StringCodec.INSTANCE.getValueDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP) {
                if (parts != null && parts.size() % 2 != 0) {
                    return data.getCodec().getMapValueDecoder();
                }
                return data.getCodec().getMapKeyDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_KEY) {
                return data.getCodec().getMapKeyDecoder();
            }
            if (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_VALUE) {
                return data.getCodec().getMapValueDecoder();
            }
            return data.getCodec().getValueDecoder();
        }
        return decoder;
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = CommandDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }
}

