/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.BitSetCodec;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.jcache.JCacheEventCodec;

public abstract class BaseCodec
implements Codec {
    public static Codec copy(ClassLoader classLoader, Codec codec) {
        if (codec instanceof StringCodec || codec instanceof ByteArrayCodec || codec instanceof LocalCachedMessageCodec || codec instanceof BitSetCodec || codec instanceof JCacheEventCodec || codec == null) {
            return codec;
        }
        try {
            return (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(classLoader, codec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

