/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.cache.StdCachedValue;

public class LFUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentNavigableMap<MapKey, LFUCachedValue> accessMap = new ConcurrentSkipListMap<MapKey, LFUCachedValue>();

    public LFUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected CachedValue create(K key, V value, long ttl, long maxIdleTime) {
        return new LFUCachedValue(this.idGenerator.incrementAndGet(), key, value, ttl, maxIdleTime);
    }

    @Override
    protected void onValueCreate(CachedValue value) {
        MapKey key = this.toKey((LFUCachedValue)value);
        this.accessMap.put(key, (LFUCachedValue)value);
    }

    @Override
    protected void onValueRead(CachedValue value) {
        this.addAccessCount((LFUCachedValue)value, 1L);
    }

    private MapKey toKey(LFUCachedValue value) {
        return new MapKey(value.accessCount, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onValueRemove(CachedValue value) {
        CachedValue cachedValue = value;
        synchronized (cachedValue) {
            MapKey key = this.toKey((LFUCachedValue)value);
            this.accessMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAccessCount(LFUCachedValue value, long count) {
        LFUCachedValue lFUCachedValue = value;
        synchronized (lFUCachedValue) {
            if (count < 0L && value.accessCount == 0L) {
                return;
            }
            MapKey key = this.toKey(value);
            if (this.accessMap.remove(key) == null) {
                return;
            }
            if (count < 0L) {
                count = -Math.min(value.accessCount, -count);
            }
            value.addAccessCount(count);
            key = this.toKey(value);
            this.accessMap.put(key, value);
        }
    }

    @Override
    protected void onMapFull() {
        Map.Entry entry = this.accessMap.pollFirstEntry();
        if (entry == null) {
            return;
        }
        this.map.remove(((LFUCachedValue)entry.getValue()).getKey(), entry.getValue());
        if (((LFUCachedValue)entry.getValue()).accessCount == 0L) {
            return;
        }
        for (LFUCachedValue value : this.accessMap.values()) {
            this.addAccessCount(value, -((LFUCachedValue)entry.getValue()).accessCount);
        }
    }

    @Override
    public void clear() {
        this.accessMap.clear();
        super.clear();
    }

    public static class LFUCachedValue
    extends StdCachedValue {
        Long id;
        long accessCount;

        public LFUCachedValue(long id, Object key, Object value, long ttl, long maxIdleTime) {
            super(key, value, ttl, maxIdleTime);
            this.id = id;
        }

        public void addAccessCount(long value) {
            this.accessCount += value;
        }
    }

    public static class MapKey
    implements Comparable<MapKey> {
        private Long accessCount;
        private LFUCachedValue cachedValue;

        public MapKey(Long accessCount, LFUCachedValue cachedValue) {
            this.accessCount = accessCount;
            this.cachedValue = cachedValue;
        }

        @Override
        public int compareTo(MapKey o) {
            int compare = this.accessCount.compareTo(o.accessCount);
            if (compare == 0) {
                return this.cachedValue.id.compareTo(o.cachedValue.id);
            }
            return compare;
        }

        public String toString() {
            return "MapKey [accessCount=" + this.accessCount + "]";
        }
    }
}

