/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonQueue;
import org.redisson.RedissonQueueSemaphore;
import org.redisson.RedissonSemaphore;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonBoundedBlockingQueue<V>
extends RedissonQueue<V>
implements RBoundedBlockingQueue<V> {
    private final CommandExecutor commandExecutor;
    private final SemaphorePubSub semaphorePubSub;

    protected RedissonBoundedBlockingQueue(SemaphorePubSub semaphorePubSub, CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.semaphorePubSub = semaphorePubSub;
        this.commandExecutor = commandExecutor;
    }

    protected RedissonBoundedBlockingQueue(SemaphorePubSub semaphorePubSub, Codec codec, CommandExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.semaphorePubSub = semaphorePubSub;
        this.commandExecutor = commandExecutor;
    }

    private String getSemaphoreName() {
        if (this.getName().contains("{")) {
            return "redisson_bqs:" + this.getName();
        }
        return "redisson_bqs:{" + this.getName() + "}";
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        RFuture<Boolean> future = this.offerAsync(e);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (!future.getNow().booleanValue()) {
                    result.tryFailure(new IllegalStateException("Queue is full"));
                    return;
                }
                result.trySuccess(future.getNow());
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.acquireAsync();
    }

    private RedissonQueueSemaphore createSemaphore(V e) {
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName(), this.semaphorePubSub);
        semaphore.setQueueName(this.getName());
        semaphore.setValue(e);
        return semaphore;
    }

    @Override
    public void put(V e) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        semaphore.acquire();
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync();
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquire(timeout, unit);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e, long timeout, TimeUnit unit) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync(timeout, unit);
    }

    @Override
    public RFuture<V> takeAsync() {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), 0);
        return this.wrapTakeFuture(takeFuture);
    }

    private RPromise<V> wrapTakeFuture(final RFuture<V> takeFuture) {
        final RedissonPromise result = new RedissonPromise<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(mayInterruptIfRunning);
                return takeFuture.cancel(mayInterruptIfRunning);
            }
        };
        takeFuture.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow() == null) {
                    result.trySuccess(takeFuture.getNow());
                    return;
                }
                RedissonBoundedBlockingQueue.this.createSemaphore(null).releaseAsync().addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        result.trySuccess(takeFuture.getNow());
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAllAsync(Collections.singleton(o));
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local count = 0; for i = 1, #ARGV, 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then count = count + 1; end; end; if count > 0 then local value = redis.call('incrby', KEYS[2], count); redis.call('publish', KEYS[3], value); return 1;end;return 0 ", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), this.encode(c).toArray());
    }

    @Override
    public RFuture<V> pollAsync() {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local res = redis.call('lpop', KEYS[1]);if res ~= false then local value = redis.call('incrby', KEYS[2], ARGV[1]); redis.call('publish', KEYS[3], value); end;return res;", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), 1);
    }

    @Override
    public V take() throws InterruptedException {
        return this.get(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), this.toSeconds(timeout, unit));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.get(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        RFuture takeFuture = this.commandExecutor.pollFromAnyAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.toSeconds(timeout, unit), queueNames);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.get(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOPLPUSH, this.getName(), queueName, unit.toSeconds(timeout));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public int remainingCapacity() {
        return this.createSemaphore(null).availablePermits();
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), maxElements);
    }

    @Override
    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getSemaphoreName(), channelName), capacity);
    }

    @Override
    public boolean trySetCapacity(int capacity) {
        return this.get(this.trySetCapacityAsync(capacity));
    }

    @Override
    public void clear() {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        this.commandExecutor.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local len = redis.call('llen', KEYS[1]); if len > 0 then redis.call('del', KEYS[1]); local value = redis.call('incrby', KEYS[2], len); redis.call('publish', KEYS[3], value); end; ", Arrays.asList(this.getName(), this.getSemaphoreName(), channelName), new Object[0]);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getSemaphoreName());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getName(), this.getSemaphoreName());
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpire', KEYS[2], ARGV[1]); return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), timeUnit.toMillis(timeToLive));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('pexpireat', KEYS[2], ARGV[1]); return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), timestamp);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('persist', KEYS[2]); return redis.call('persist', KEYS[1]); ", Arrays.asList(this.getName(), this.getSemaphoreName()), new Object[0]);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName(), this.semaphorePubSub);
        semaphore.setQueueName(this.getName());
        semaphore.setValues(c);
        return semaphore.tryAcquireAsync();
    }
}

