/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonRxClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.redisson.rx.CommandRxService;
import reactor.rx.action.support.DefaultSubscriber;

public class CommandRxBatchService
extends CommandRxService {
    private final CommandBatchService batchService;
    private final Queue<Publisher<?>> publishers = new ConcurrentLinkedQueue();

    public CommandRxBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
        this.batchService = new CommandBatchService(connectionManager);
    }

    @Override
    public <R> Flowable<R> flowable(Callable<RFuture<R>> supplier) {
        Flowable<R> flowable = super.flowable(supplier);
        this.publishers.add(flowable);
        return flowable;
    }

    public <R> Flowable<R> superReactive(Callable<RFuture<R>> supplier) {
        return super.flowable(supplier);
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt, boolean ignoreRedirect) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, attempt, ignoreRedirect);
    }

    public RFuture<BatchResult<?>> executeAsync(BatchOptions options) {
        for (Publisher publisher : this.publishers) {
            publisher.subscribe(new DefaultSubscriber<Object>(){

                @Override
                public void onSubscribe(Subscription s) {
                    s.request(1L);
                }
            });
        }
        return this.batchService.executeAsync(options);
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonRxClient redissonReactive) {
        this.batchService.enableRedissonReferenceSupport(redissonReactive);
        return super.enableRedissonReferenceSupport(redissonReactive);
    }
}

