/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetCacheReactive;
import org.redisson.api.RSetReactive;
import org.redisson.api.RTransaction;
import org.redisson.api.RTransactionReactive;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.ReactiveProxyBuilder;
import org.redisson.reactive.RedissonMapCacheReactive;
import org.redisson.reactive.RedissonMapReactive;
import org.redisson.reactive.RedissonSetCacheReactive;
import org.redisson.reactive.RedissonSetReactive;
import org.redisson.transaction.RedissonTransaction;
import reactor.fn.Supplier;

public class RedissonTransactionReactive
implements RTransactionReactive {
    private final RTransaction transaction;
    private final CommandReactiveExecutor executorService;

    public RedissonTransactionReactive(CommandReactiveExecutor executorService, TransactionOptions options) {
        this.transaction = new RedissonTransaction(executorService, options);
        this.executorService = executorService;
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name) {
        return ReactiveProxyBuilder.create(this.executorService, this.transaction.getBucket(name), RBucketReactive.class);
    }

    @Override
    public <V> RBucketReactive<V> getBucket(String name, Codec codec) {
        return ReactiveProxyBuilder.create(this.executorService, this.transaction.getBucket(name, codec), RBucketReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name) {
        RMap map = this.transaction.getMap(name);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapReactive(map), RMapReactive.class);
    }

    @Override
    public <K, V> RMapReactive<K, V> getMap(String name, Codec codec) {
        RMap map = this.transaction.getMap(name, codec);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapReactive(map), RMapReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name, Codec codec) {
        RMapCache map = this.transaction.getMapCache(name, codec);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <K, V> RMapCacheReactive<K, V> getMapCache(String name) {
        RMapCache map = this.transaction.getMapCache(name);
        return ReactiveProxyBuilder.create(this.executorService, map, new RedissonMapCacheReactive(map), RMapCacheReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name) {
        RSet set = this.transaction.getSet(name);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetReactive(set), RSetReactive.class);
    }

    @Override
    public <V> RSetReactive<V> getSet(String name, Codec codec) {
        RSet set = this.transaction.getSet(name, codec);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetReactive(set), RSetReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name) {
        RSetCache set = this.transaction.getSetCache(name);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetCacheReactive(set), RSetCacheReactive.class);
    }

    @Override
    public <V> RSetCacheReactive<V> getSetCache(String name, Codec codec) {
        RSetCache set = this.transaction.getSetCache(name, codec);
        return ReactiveProxyBuilder.create(this.executorService, set, new RedissonSetCacheReactive(set), RSetCacheReactive.class);
    }

    @Override
    public Publisher<Void> commit() {
        return this.executorService.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonTransactionReactive.this.transaction.commitAsync();
            }
        });
    }

    @Override
    public Publisher<Void> rollback() {
        return this.executorService.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonTransactionReactive.this.transaction.rollbackAsync();
            }
        });
    }
}

