/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelaySubscriptionOther<T, U>
extends Flowable<T> {
    final Publisher<? extends T> main;
    final Publisher<U> other;

    public FlowableDelaySubscriptionOther(Publisher<? extends T> main, Publisher<U> other) {
        this.main = main;
        this.other = other;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> child) {
        SubscriptionArbiter serial = new SubscriptionArbiter();
        child.onSubscribe(serial);
        DelaySubscriber otherSubscriber = new DelaySubscriber(serial, child);
        this.other.subscribe(otherSubscriber);
    }

    final class DelaySubscriber
    implements FlowableSubscriber<U> {
        final SubscriptionArbiter serial;
        final Subscriber<? super T> child;
        boolean done;

        DelaySubscriber(SubscriptionArbiter serial, Subscriber<? super T> child) {
            this.serial = serial;
            this.child = child;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.serial.setSubscription(new DelaySubscription(s));
            s.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(U t) {
            this.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            this.child.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            FlowableDelaySubscriptionOther.this.main.subscribe(new OnCompleteSubscriber());
        }

        final class OnCompleteSubscriber
        implements FlowableSubscriber<T> {
            OnCompleteSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription s) {
                DelaySubscriber.this.serial.setSubscription(s);
            }

            @Override
            public void onNext(T t) {
                DelaySubscriber.this.child.onNext(t);
            }

            @Override
            public void onError(Throwable t) {
                DelaySubscriber.this.child.onError(t);
            }

            @Override
            public void onComplete() {
                DelaySubscriber.this.child.onComplete();
            }
        }

        final class DelaySubscription
        implements Subscription {
            private final Subscription s;

            DelaySubscription(Subscription s) {
                this.s = s;
            }

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
                this.s.cancel();
            }
        }
    }
}

