/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketGetAndSetOperation<V>
extends TransactionalOperation {
    private Object value;
    private String lockName;

    public BucketGetAndSetOperation(String name, String lockName, Codec codec, Object value) {
        super(name, codec);
        this.value = value;
        this.lockName = lockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<Object> bucket = new RedissonBucket<Object>(this.codec, commandExecutor, this.name);
        bucket.getAndSetAsync(this.value);
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }
}

