/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.rx.PublisherAdder;
import org.redisson.rx.SetRxIterator;

public class RedissonSetRx<V> {
    private final RSet<V> instance;

    public RedissonSetRx(RSet<V> instance) {
        this.instance = instance;
    }

    public Flowable<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<Object>(){

            @Override
            public RFuture<Boolean> add(Object e) {
                return RedissonSetRx.this.instance.addAsync(e);
            }
        }.addAll(c);
    }

    public Flowable<V> iterator(int count) {
        return this.iterator(null, count);
    }

    public Flowable<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    public Flowable<V> iterator(final String pattern, final int count) {
        return new SetRxIterator<V>(){

            @Override
            protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((RedissonSet)RedissonSetRx.this.instance).scanIteratorAsync(RedissonSetRx.this.instance.getName(), client, nextIterPos, pattern, count);
            }
        }.create();
    }

    public Publisher<V> iterator() {
        return this.iterator(null, 10);
    }
}

