/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.concurrent.Callable;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.rx.CommandRxExecutor;

public class CommandRxService
extends CommandAsyncService
implements CommandRxExecutor {
    public CommandRxService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<RFuture<R>> supplier) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long t) throws Exception {
                ((RFuture)supplier.call()).addListener(new FutureListener<R>(){

                    @Override
                    public void operationComplete(Future<R> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        if (future.getNow() != null) {
                            p.onNext(future.getNow());
                        }
                        p.onComplete();
                    }
                });
            }
        });
    }
}

