/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.reactivestreams;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscription;

public class SubscriptionWithContext<C>
implements Subscription {
    private volatile long pending = 0L;
    protected static final AtomicLongFieldUpdater<SubscriptionWithContext> PENDING_UPDATER = AtomicLongFieldUpdater.newUpdater(SubscriptionWithContext.class, "pending");
    private volatile int terminated = 0;
    protected static final AtomicIntegerFieldUpdater<SubscriptionWithContext> TERMINATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SubscriptionWithContext.class, "terminated");
    protected final C context;
    protected final Subscription subscription;

    public static <C> SubscriptionWithContext<C> create(Subscription subscription, C context) {
        return new SubscriptionWithContext<C>(context, subscription);
    }

    protected SubscriptionWithContext(C context, Subscription subscription) {
        this.context = context;
        this.subscription = subscription;
    }

    public C context() {
        return this.context;
    }

    @Override
    public void request(long n) {
        this.subscription.request(n);
    }

    @Override
    public void cancel() {
        if (TERMINATED_UPDATER.compareAndSet(this, 0, 1)) {
            this.subscription.cancel();
        }
    }

    public boolean isCancelled() {
        return this.terminated == 1;
    }
}

