/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonReference;
import org.redisson.api.RFuture;
import org.redisson.api.RObjectAsync;
import org.redisson.api.RObjectReactive;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.misc.RedissonObjectFactory;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.Streams;

abstract class RedissonObjectReactive
implements RObjectReactive {
    final CommandReactiveExecutor commandExecutor;
    private final String name;
    final Codec codec;
    protected RObjectAsync instance;

    public RedissonObjectReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, RObjectAsync instance) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
        this.instance = instance;
    }

    public <R> Publisher<R> reactive(Supplier<RFuture<R>> supplier) {
        return this.commandExecutor.reactive(supplier);
    }

    public RedissonObjectReactive(CommandReactiveExecutor commandExecutor, String name, RObjectAsync instance) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name, instance);
    }

    protected <V> Stream<V> newSucceeded(V result) {
        return Streams.just(result);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected void encode(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encode(object));
        }
    }

    protected ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapKey(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapKeyEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected ByteBuf encodeMapValue(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = RedissonObjectFactory.toReference(this.commandExecutor.getConnectionManager().getCfg(), value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Publisher<Void> restore(final byte[] state) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.restoreAsync(state);
            }
        });
    }

    @Override
    public Publisher<Void> restore(final byte[] state, final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.restoreAsync(state, timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Void> restoreAndReplace(final byte[] state) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.restoreAndReplaceAsync(state);
            }
        });
    }

    @Override
    public Publisher<Void> restoreAndReplace(final byte[] state, final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.restoreAndReplaceAsync(state, timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<byte[]> dump() {
        return this.reactive(new Supplier<RFuture<byte[]>>(){

            @Override
            public RFuture<byte[]> get() {
                return RedissonObjectReactive.this.instance.dumpAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> touch() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.touchAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> unlink() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.unlinkAsync();
            }
        });
    }

    @Override
    public Publisher<Void> copy(final String host, final int port, final int database, final long timeout) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.copyAsync(host, port, database, timeout);
            }
        });
    }

    @Override
    public Publisher<Void> rename(final String newName) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.renameAsync(newName);
            }
        });
    }

    @Override
    public Publisher<Void> migrate(final String host, final int port, final int database, final long timeout) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonObjectReactive.this.instance.migrateAsync(host, port, database, timeout);
            }
        });
    }

    @Override
    public Publisher<Boolean> move(final int database) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.moveAsync(database);
            }
        });
    }

    @Override
    public Publisher<Boolean> renamenx(final String newName) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.renamenxAsync(newName);
            }
        });
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.deleteAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> isExists() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonObjectReactive.this.instance.isExistsAsync();
            }
        });
    }
}

