/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonBaseAdder;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RFuture;
import org.redisson.api.RLongAdder;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonLongAdder
extends RedissonBaseAdder<Long>
implements RLongAdder {
    private final RAtomicLong atomicLong;
    private final AtomicLong counter = new AtomicLong();

    public RedissonLongAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
        this.atomicLong = redisson.getAtomicLong(this.getName());
    }

    @Override
    protected void doReset() {
        this.counter.set(0L);
    }

    @Override
    protected RFuture<Long> addAndGetAsync() {
        return this.atomicLong.getAndAddAsync(this.counter.get());
    }

    @Override
    protected RFuture<Long> getAndDeleteAsync() {
        return this.atomicLong.getAndDeleteAsync();
    }

    @Override
    public void add(long x) {
        this.counter.addAndGet(x);
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    @Override
    public void decrement() {
        this.add(-1L);
    }

    @Override
    public long sum() {
        return (Long)this.get(this.sumAsync());
    }
}

