/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.redisson.Redisson;
import org.redisson.RedissonBaseMapIterator;
import org.redisson.RedissonObject;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.jcache.JCacheEntry;
import org.redisson.jcache.JCacheEntryEvent;
import org.redisson.jcache.JCacheEventCodec;
import org.redisson.jcache.JCacheManager;
import org.redisson.jcache.JMutableEntry;
import org.redisson.jcache.configuration.JCacheConfiguration;
import org.redisson.misc.Hash;

public class JCache<K, V>
extends RedissonObject
implements Cache<K, V> {
    private final JCacheManager cacheManager;
    private final JCacheConfiguration<K, V> config;
    private final ConcurrentMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>> listeners = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>>();
    private final Redisson redisson;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private boolean closed;
    private boolean hasOwnRedisson;

    public JCache(JCacheManager cacheManager, Redisson redisson, String name, JCacheConfiguration<K, V> config, boolean hasOwnRedisson) {
        super(redisson.getConfig().getCodec(), redisson.getCommandExecutor(), name);
        this.hasOwnRedisson = hasOwnRedisson;
        this.redisson = redisson;
        Factory<CacheLoader<K, V>> cacheLoaderFactory = config.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            this.cacheLoader = cacheLoaderFactory.create();
        }
        Factory<CacheWriter<K, V>> cacheWriterFactory = config.getCacheWriterFactory();
        if (config.getCacheWriterFactory() != null) {
            this.cacheWriter = cacheWriterFactory.create();
        }
        this.cacheManager = cacheManager;
        this.config = config;
        redisson.getEvictionScheduler().scheduleJCache(this.getName(), this.getTimeoutSetName(), this.getExpiredChannelName());
        for (CacheEntryListenerConfiguration<K, V> listenerConfig : config.getCacheEntryListenerConfigurations()) {
            this.registerCacheEntryListener(listenerConfig, false);
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    String getTimeoutSetName() {
        return "jcache_timeout_set:{" + this.getName() + "}";
    }

    String getSyncName(Object syncId) {
        return "jcache_sync:" + syncId + ":{" + this.getName() + "}";
    }

    String getCreatedSyncChannelName() {
        return "jcache_created_sync_channel:{" + this.getName() + "}";
    }

    String getUpdatedSyncChannelName() {
        return "jcache_updated_sync_channel:{" + this.getName() + "}";
    }

    String getRemovedSyncChannelName() {
        return "jcache_removed_sync_channel:{" + this.getName() + "}";
    }

    String getCreatedChannelName() {
        return "jcache_created_channel:{" + this.getName() + "}";
    }

    String getUpdatedChannelName() {
        return "jcache_updated_channel:{" + this.getName() + "}";
    }

    String getExpiredChannelName() {
        return "jcache_expired_channel:{" + this.getName() + "}";
    }

    String getRemovedChannelName() {
        return "jcache_removed_channel:{" + this.getName() + "}";
    }

    private long currentNanoTime() {
        if (this.config.isStatisticsEnabled()) {
            return System.nanoTime();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RLock lock = this.getLockedLock(key);
        try {
            V value = this.getValueLocked(key);
            if (value == null) {
                this.cacheManager.getStatBean(this).addMisses(1L);
                if (this.config.isReadThrough()) {
                    value = this.loadValue(key);
                }
            } else {
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addHits(1L);
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    V getValueLocked(K key) {
        Object value = this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; return value; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key));
        if (value != null) {
            ArrayList<Object> result = new ArrayList<Object>(3);
            result.add(value);
            Long accessTimeout = this.getAccessTimeout();
            double syncId = PlatformDependent.threadLocalRandom().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[4]); local syncs = redis.call('publish', KEYS[4], syncMsg); return syncs;elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return 0;end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), syncId);
            result.add(syncs);
            result.add(syncId);
            this.waitSync(result);
            return (V)value;
        }
        return (V)value;
    }

    private V getValue(K key) {
        Long accessTimeout = this.getAccessTimeout();
        Object value = this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return value; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key));
        return (V)value;
    }

    private Long getAccessTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForAccess() == null) {
            return -1L;
        }
        Long accessTimeout = this.config.getExpiryPolicy().getExpiryForAccess().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForAccess().isZero()) {
            accessTimeout = 0L;
        } else if (accessTimeout == Long.MAX_VALUE) {
            accessTimeout = -1L;
        }
        return accessTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V load(K key) {
        RLock lock = this.getLockedLock(key);
        try {
            V value = this.getValueLocked(key);
            if (value == null) {
                value = this.loadValue(key);
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private V loadValue(K key) {
        V value = null;
        try {
            value = this.cacheLoader.load(key);
        }
        catch (Exception ex) {
            throw new CacheLoaderException(ex);
        }
        if (value != null) {
            long startTime = this.currentNanoTime();
            this.putValueLocked(key, value);
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        }
        return value;
    }

    private <T, R> R write(String key, RedisCommand<T> command, Object ... params) {
        RFuture future = this.commandExecutor.writeAsync(key, command, params);
        try {
            return (R)this.get((K)future);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    private <T, R> R evalWrite(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture future = this.commandExecutor.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
        try {
            return (R)this.get((K)future);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    private boolean putValueLocked(K key, Object value) {
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        if (this.containsKey(key)) {
            Long updateTimeout = this.getUpdateTimeout();
            List res = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {0, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getCreatedSyncChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            res.add(syncId);
            this.waitSync(res);
            return (Long)res.get(0) == 1L;
        }
        Long creationTimeout = this.getCreationTimeout();
        List res = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] == '0' then return {0};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getCreatedSyncChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), creationTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        res.add(syncId);
        this.waitSync(res);
        return (Long)res.get(0) == 1L;
    }

    private boolean putValue(K key, Object value) {
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        List res = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "if redis.call('hexists', KEYS[1], ARGV[4]) == 1 then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {0, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};end; else if ARGV[1] == '0' then return {0};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getCreatedSyncChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), creationTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        res.add(syncId);
        this.waitSync(res);
        return (Long)res.get(0) == 1L;
    }

    private Long getUpdateTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForUpdate() == null) {
            return -1L;
        }
        Long updateTimeout = this.config.getExpiryPolicy().getExpiryForUpdate().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForUpdate().isZero()) {
            updateTimeout = 0L;
        } else if (updateTimeout == Long.MAX_VALUE) {
            updateTimeout = -1L;
        }
        return updateTimeout;
    }

    private Long getCreationTimeout() {
        if (this.config.getExpiryPolicy().getExpiryForCreation() == null) {
            return -1L;
        }
        Long creationTimeout = this.config.getExpiryPolicy().getExpiryForCreation().getAdjustedTime(System.currentTimeMillis());
        if (this.config.getExpiryPolicy().getExpiryForCreation().isZero()) {
            creationTimeout = 0L;
        } else if (creationTimeout == Long.MAX_VALUE) {
            creationTimeout = -1L;
        }
        return creationTimeout;
    }

    private boolean putIfAbsentValue(K key, Object value) {
        Long creationTimeout = this.getCreationTimeout();
        return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[2]) == 1 then return 0; else if ARGV[1] == '0' then return 0;elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName()), creationTimeout, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    private boolean putIfAbsentValueLocked(K key, Object value) {
        if (this.containsKey(key)) {
            return false;
        }
        Long creationTimeout = this.getCreationTimeout();
        return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[1] == '0' then return 0;elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName()), creationTimeout, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockName(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = "{" + this.getName() + "}:" + Hash.hash128toBase64(keyState) + ":key";
            return string;
        }
        finally {
            keyState.release();
        }
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        boolean exists = false;
        for (K key : keys) {
            if (!this.containsKey(key)) continue;
            exists = true;
        }
        if (!exists && !this.config.isReadThrough()) {
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            return Collections.emptyMap();
        }
        Long accessTimeout = this.getAccessTimeout();
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 2);
        args.add(accessTimeout);
        args.add(System.currentTimeMillis());
        this.encode(args, keys);
        Map res = (Map)this.evalWrite(this.getName(), this.codec, new RedisCommand<Map<Object, Object>>("EVAL", new MapGetAllDecoder(new ArrayList<K>(keys), 0), RedisCommand.ValueType.MAP_VALUE), "local expireHead = redis.call('zrange', KEYS[2], 0, 0, 'withscores');local accessTimeout = ARGV[1]; local currentTime = tonumber(ARGV[2]); local hasExpire = #expireHead == 2 and tonumber(expireHead[2]) <= currentTime; local map = redis.call('hmget', KEYS[1], unpack(ARGV, 3, #ARGV)); local result = {};for i, value in ipairs(map) do if value ~= false then local key = ARGV[i+2]; if hasExpire then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= currentTime then value = false; end; end; if accessTimeout == '0' then redis.call('hdel', KEYS[1], key); redis.call('zrem', KEYS[2], key); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(value), value); redis.call('publish', KEYS[3], {key, value}); elseif accessTimeout ~= '-1' then redis.call('zadd', KEYS[2], accessTimeout, key); end; end; table.insert(result, value); end; return result;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), args.toArray());
        HashMap result = new HashMap();
        for (Map.Entry entry : res.entrySet()) {
            if (entry.getValue() != null) {
                this.cacheManager.getStatBean(this).addHits(1L);
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!this.config.isReadThrough()) continue;
            this.cacheManager.getStatBean(this).addMisses(1L);
            V value = this.load(entry.getKey());
            if (value == null) continue;
            result.put(entry.getKey(), value);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        return result;
    }

    @Override
    public boolean containsKey(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[2]) == 0 then return 0;end;local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return 0; end; return 1;", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    @Override
    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Object key : keys) {
                    try {
                        if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                        RLock lock = JCache.this.getLockedLock(key);
                        try {
                            Object value;
                            if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                            try {
                                value = JCache.this.cacheLoader.load(key);
                            }
                            catch (Exception ex) {
                                throw new CacheLoaderException(ex);
                            }
                            if (value == null) continue;
                            JCache.this.putValueLocked(key, value);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (completionListener != null) {
                            completionListener.onException(e);
                        }
                        return;
                    }
                }
                if (completionListener != null) {
                    completionListener.onCompletion();
                }
            }
        });
    }

    private RLock getLockedLock(K key) {
        String lockName = this.getLockName(key);
        RLock lock = this.redisson.getLock(lockName);
        try {
            lock.lock();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                List<Object> result = this.getAndPutValueLocked(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    return;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    return;
                }
                if (Long.valueOf(1L).equals(added)) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (result.size() == 4 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (result.size() == 4 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addPuts(1L);
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            boolean result = this.putValueLocked(key, value);
            if (result) {
                this.cacheManager.getStatBean(this).addPuts(1L);
            }
        }
        finally {
            lock.unlock();
        }
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
    }

    private long removeValues(Object ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length);
        this.encodeMapKeys(params, Arrays.asList(keys));
        return (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "redis.call('zrem', KEYS[2], unpack(ARGV)); return redis.call('hdel', KEYS[1], unpack(ARGV)); ", Arrays.asList(this.getName(), this.getTimeoutSetName()), params.toArray());
    }

    private List<Object> getAndPutValueLocked(K key, V value) {
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        if (this.containsKey(key)) {
            Long updateTimeout = this.getUpdateTimeout();
            List result = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hget', KEYS[1], ARGV[4]);if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {0, value, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getCreatedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getCreatedSyncChannelName(), this.getUpdatedSyncChannelName()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            result.add(syncId);
            this.waitSync(result);
            return result;
        }
        Long creationTimeout = this.getCreationTimeout();
        List result = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] == '0' then return {nil};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getCreatedSyncChannelName()), creationTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        result.add(syncId);
        this.waitSync(result);
        return result;
    }

    private List<Object> getAndPutValue(K key, V value) {
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        List result = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hget', KEYS[1], ARGV[4]);if value ~= false then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {0, value, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[5], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};end; else if ARGV[1] == '0' then return {nil};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {1, syncs};end; end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getCreatedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getCreatedSyncChannelName(), this.getUpdatedSyncChannelName()), creationTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        if (!result.isEmpty()) {
            result.add(syncId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndPut(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                List<Object> result = this.getAndPutValueLocked(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addMisses(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    V v = null;
                    return v;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    Object object = result.get(1);
                    return (V)object;
                }
                if (Long.valueOf(1L).equals(added)) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (result.size() == 4 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (result.size() == 4 && result.get(1) != null) {
                        this.putValue(key, result.get(1));
                    }
                    throw new CacheWriterException(e);
                }
                V v = this.getAndPutResult(startTime, result);
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            List<Object> result = this.getAndPutValueLocked(key, value);
            V v = this.getAndPutResult(startTime, result);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private V getAndPutResult(long startTime, List<Object> result) {
        if (result.size() != 4) {
            this.cacheManager.getStatBean(this).addPuts(1L);
            this.cacheManager.getStatBean(this).addMisses(1L);
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            return null;
        }
        this.cacheManager.getStatBean(this).addPuts(1L);
        this.cacheManager.getStatBean(this).addHits(1L);
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return (V)result.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkNotClosed();
        HashMap deletedKeys = new HashMap();
        HashMap addedEntries = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            if (k == null) {
                throw new NullPointerException();
            }
            Object value = entry.getValue();
            if (value != null) continue;
            throw new NullPointerException();
        }
        ArrayList<RLock> lockedLocks = new ArrayList<RLock>();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            long startTime = this.currentNanoTime();
            if (this.config.isWriteThrough()) {
                RLock lock = this.getLockedLock(key);
                lockedLocks.add(lock);
                List<Object> result = this.getAndPutValue(key, value);
                if (result.isEmpty()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    continue;
                }
                Long added = (Long)result.get(0);
                if (added == null) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    continue;
                }
                if (Long.valueOf(1L).equals(added)) {
                    addedEntries.put(key, new JCacheEntry(key, value));
                } else {
                    Object val = null;
                    if (result.size() == 4) {
                        val = result.get(1);
                    }
                    deletedKeys.put(key, val);
                }
                this.cacheManager.getStatBean(this).addPuts(1L);
                this.waitSync(result);
            } else {
                boolean result = this.putValue(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                }
            }
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        }
        if (this.config.isWriteThrough()) {
            try {
                try {
                    this.cacheWriter.writeAll(addedEntries.values());
                }
                catch (CacheWriterException e) {
                    this.removeValues(addedEntries.keySet().toArray());
                    throw e;
                }
                catch (Exception e) {
                    this.removeValues(addedEntries.keySet().toArray());
                    throw new CacheWriterException(e);
                }
                try {
                    this.cacheWriter.deleteAll(deletedKeys.keySet());
                }
                catch (CacheWriterException e) {
                    for (Map.Entry deletedEntry : deletedKeys.entrySet()) {
                        if (deletedEntry.getValue() == null) continue;
                        this.putValue(deletedEntry.getKey(), deletedEntry.getValue());
                    }
                    throw e;
                }
                catch (Exception e) {
                    for (Map.Entry deletedEntry : deletedKeys.entrySet()) {
                        if (deletedEntry.getValue() == null) continue;
                        this.putValue(deletedEntry.getKey(), deletedEntry.getValue());
                    }
                    throw new CacheWriterException(e);
                }
            }
            finally {
                for (RLock rLock : lockedLocks) {
                    rLock.unlock();
                }
            }
        }
    }

    void waitSync(List<Object> result) {
        if (result.size() < 2) {
            return;
        }
        Long syncs = (Long)result.get(result.size() - 2);
        Double syncId = (Double)result.get(result.size() - 1);
        if (syncs != null && syncs > 0L) {
            RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
            try {
                semaphore.acquire(syncs.intValue());
                semaphore.delete();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                boolean result = this.putIfAbsentValueLocked(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            boolean result = this.putIfAbsentValueLocked(key, value);
            if (result) {
                this.cacheManager.getStatBean(this).addPuts(1L);
            }
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean removeValue(K key) {
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        List res = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hexists', KEYS[1], ARGV[2]); if value == 0 then return {0}; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return {0}; end; value = redis.call('hget', KEYS[1], ARGV[2]); redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value), ARGV[3]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), System.currentTimeMillis(), this.encodeMapKey(key), syncId);
        res.add(syncId);
        this.waitSync(res);
        return (Long)res.get(0) == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = System.currentTimeMillis();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                V oldValue = this.getValue(key);
                boolean result = this.removeValue(key);
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (oldValue != null) {
                        this.putValue(key, oldValue);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (oldValue != null) {
                        this.putValue(key, oldValue);
                    }
                    throw new CacheWriterException(e);
                }
                if (result) {
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                }
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        boolean result = this.removeValue(key);
        if (result) {
            this.cacheManager.getStatBean(this).addRemovals(1L);
        }
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        return result;
    }

    private boolean removeValueLocked(K key, V value) {
        Boolean result = (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return 0; end; if ARGV[4] == value then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; end; return nil;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        if (result == null) {
            Long accessTimeout = this.getAccessTimeout();
            return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        }
        return result;
    }

    private boolean removeValue(K key, V value) {
        Long accessTimeout = this.getAccessTimeout();
        return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return 0; end; if ARGV[4] == value then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                boolean result = this.removeValueLocked(key, value);
                if (result) {
                    try {
                        this.cacheWriter.delete(key);
                    }
                    catch (CacheWriterException e) {
                        this.putValue(key, value);
                        throw e;
                    }
                    catch (Exception e) {
                        this.putValue(key, value);
                        throw new CacheWriterException(e);
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                    this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    boolean bl = true;
                    return bl;
                }
                this.cacheManager.getStatBean(this).addMisses(1L);
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            boolean result = this.removeValueLocked(key, value);
            if (result) {
                this.cacheManager.getStatBean(this).addHits(1L);
                this.cacheManager.getStatBean(this).addRemovals(1L);
            } else {
                this.cacheManager.getStatBean(this).addMisses(1L);
            }
            this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private V getAndRemoveValue(K key) {
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        List result = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return {nil}; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[1]) then return {nil}; end; redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value), ARGV[3]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {value, syncs}; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), System.currentTimeMillis(), this.encodeMapKey(key), syncId);
        if (result.isEmpty()) {
            return null;
        }
        result.add(syncId);
        this.waitSync(result);
        return (V)result.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndRemove(K key) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                V value = this.getAndRemoveValue(key);
                if (value != null) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    if (value != null) {
                        this.putValue(key, value);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (value != null) {
                        this.putValue(key, value);
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                V v = value;
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        V value = this.getAndRemoveValue(key);
        if (value != null) {
            this.cacheManager.getStatBean(this).addHits(1L);
            this.cacheManager.getStatBean(this).addRemovals(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        return value;
    }

    private long replaceValueLocked(K key, V oldValue, V newValue) {
        Long res = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local value = redis.call('hget', KEYS[1], ARGV[4]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[3]) then return 0; end; if ARGV[5] == value then return 1;end; return -1;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), 0, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
        if (res == 1L) {
            Long updateTimeout = this.getUpdateTimeout();
            double syncId = PlatformDependent.threadLocalRandom().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[7]); return redis.call('publish', KEYS[5], syncMsg); elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], ARGV[7]); return redis.call('publish', KEYS[6], syncMsg); else redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], ARGV[7]); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
            return res;
        }
        if (res == 0L) {
            return res;
        }
        Long accessTimeout = this.getAccessTimeout();
        double syncId = PlatformDependent.threadLocalRandom().nextDouble();
        List result = (List)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(value), value); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(value), value, ARGV[7]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {-1, syncs}; elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return {0};end; return {-1}; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), accessTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue), syncId);
        result.add(syncId);
        this.waitSync(result);
        return (Long)result.get(0);
    }

    private long replaceValue(K key, V oldValue, V newValue) {
        Long accessTimeout = this.getAccessTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        return (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local value = redis.call('hget', KEYS[1], ARGV[4]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[3]) then return 0; end; if ARGV[5] == value then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); end; return 1;end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(value), value); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return 0;end; return -1; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), accessTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                long result = this.replaceValueLocked(key, oldValue, newValue);
                if (result == 1L) {
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, newValue));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    boolean bl = true;
                    return bl;
                }
                if (result == 0L) {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                } else {
                    this.cacheManager.getStatBean(this).addHits(1L);
                }
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            long result = this.replaceValueLocked(key, oldValue, newValue);
            if (result == 1L) {
                this.cacheManager.getStatBean(this).addHits(1L);
                this.cacheManager.getStatBean(this).addPuts(1L);
            } else if (result == 0L) {
                this.cacheManager.getStatBean(this).addMisses(1L);
            } else {
                this.cacheManager.getStatBean(this).addHits(1L);
            }
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            boolean bl = result == 1L;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean replaceValueLocked(K key, V value) {
        if (this.containsKey(key)) {
            double syncId = PlatformDependent.threadLocalRandom().nextDouble();
            Long updateTimeout = this.getUpdateTimeout();
            Long syncs = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[5]); return redis.call('publish', KEYS[5], syncMsg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], ARGV[5]); return redis.call('publish', KEYS[6], syncMsg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], ARGV[5]); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
            return true;
        }
        return false;
    }

    private boolean replaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        return (Boolean)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return 0; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); end; return 1;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    private V getAndReplaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        return (V)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); end; return value;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    private V getAndReplaceValueLocked(K key, V value) {
        Object oldValue = this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore); end; if expireDate <= tonumber(ARGV[2]) then return nil; end; return value;", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        if (oldValue != null) {
            Long updateTimeout = this.getUpdateTimeout();
            double syncId = PlatformDependent.threadLocalRandom().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then local value = redis.call('hget', KEYS[1], ARGV[3]); redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[5]); return redis.call('publish', KEYS[5], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], ARGV[5]); return redis.call('publish', KEYS[6], syncMsg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], ARGV[5]); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
        }
        return (V)oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                boolean result = this.replaceValueLocked(key, value);
                if (result) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                boolean bl = result;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            boolean result = this.replaceValueLocked(key, value);
            if (result) {
                this.cacheManager.getStatBean(this).addHits(1L);
                this.cacheManager.getStatBean(this).addPuts(1L);
            } else {
                this.cacheManager.getStatBean(this).addMisses(1L);
            }
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndReplace(K key, V value) {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                V result = this.getAndReplaceValueLocked(key, value);
                if (result != null) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    try {
                        this.cacheWriter.write(new JCacheEntry<K, V>(key, value));
                    }
                    catch (CacheWriterException e) {
                        this.removeValues(key);
                        throw e;
                    }
                    catch (Exception e) {
                        this.removeValues(key);
                        throw new CacheWriterException(e);
                    }
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                V v = result;
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            V result = this.getAndReplaceValueLocked(key, value);
            if (result != null) {
                this.cacheManager.getStatBean(this).addHits(1L);
                this.cacheManager.getStatBean(this).addPuts(1L);
            } else {
                this.cacheManager.getStatBean(this).addMisses(1L);
            }
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            V v = result;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        HashMap<Object, V> deletedKeys = new HashMap<Object, V>();
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        ArrayList<RLock> lockedLocks = new ArrayList<RLock>();
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            for (Object key : keys) {
                RLock rLock = this.getLockedLock(key);
                lockedLocks.add(rLock);
                V result = this.getAndRemoveValue(key);
                if (result == null) continue;
                deletedKeys.put(key, result);
            }
            try {
                try {
                    this.cacheWriter.deleteAll(deletedKeys.keySet());
                }
                catch (CacheWriterException e) {
                    for (Map.Entry entry : deletedKeys.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.putValue(entry.getKey(), entry.getValue());
                    }
                    throw e;
                }
                catch (Exception e) {
                    for (Map.Entry entry : deletedKeys.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.putValue(entry.getKey(), entry.getValue());
                    }
                    throw new CacheWriterException(e);
                }
                this.cacheManager.getStatBean(this).addRemovals(deletedKeys.size());
            }
            finally {
                for (RLock lock : lockedLocks) {
                    lock.unlock();
                }
            }
        }
        long removedKeys = this.removeValues(keys.toArray());
        this.cacheManager.getStatBean(this).addRemovals(removedKeys);
        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
    }

    MapScanResult<Object, Object> scanIterator(String name, RedisClient client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos);
        try {
            return (MapScanResult)this.get((K)f);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    protected Iterator<K> keyIterator() {
        return new RedissonBaseMapIterator<K>(){

            @Override
            protected K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }

            @Override
            protected void remove(Map.Entry<Object, Object> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected Object put(Map.Entry<Object, Object> entry, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, long nextIterPos) {
                return JCache.this.scanIterator(JCache.this.getName(), client, nextIterPos);
            }
        };
    }

    @Override
    public void removeAll() {
        this.checkNotClosed();
        if (this.config.isWriteThrough()) {
            Iterator<K> iterator = this.keyIterator();
            while (iterator.hasNext()) {
                K key = iterator.next();
                this.remove(key);
            }
        } else {
            long startTime = this.currentNanoTime();
            long removedObjects = (Long)this.evalWrite(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local expiredEntriesCount = redis.call('zcount', KEYS[2], 0, ARGV[1]); local result = 0; if expiredEntriesCount > 0 then result = redis.call('zcard', KEYS[2]) - expiredEntriesCount; else result = redis.call('hlen', KEYS[1]); end; redis.call('del', KEYS[1], KEYS[2]); return result; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis());
            this.cacheManager.getStatBean(this).addRemovals(removedObjects);
            this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        }
    }

    @Override
    public void clear() {
        this.checkNotClosed();
        this.write(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getTimeoutSetName());
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.config)) {
            return (C)((Configuration)clazz.cast(this.config));
        }
        throw new IllegalArgumentException("Configuration object is not an instance of " + clazz);
    }

    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.checkNotClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.containsKey(key)) {
            this.cacheManager.getStatBean(this).addHits(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        JMutableEntry<K, Object> entry = new JMutableEntry<K, Object>(this, key, null, this.config.isReadThrough());
        RLock lock = this.getLockedLock(key);
        try {
            T result = entryProcessor.process(entry, arguments);
            if (entry.getAction() == JMutableEntry.Action.CREATED || entry.getAction() == JMutableEntry.Action.UPDATED) {
                this.put(key, entry.value());
            }
            if (entry.getAction() == JMutableEntry.Action.DELETED) {
                this.remove(key);
            }
            T t = result;
            return t;
        }
        catch (EntryProcessorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EntryProcessorException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap results = new HashMap();
        for (K key : keys) {
            try {
                final T result = this.invoke(key, entryProcessor, arguments);
                if (result == null) continue;
                results.put(key, new EntryProcessorResult<T>(){

                    @Override
                    public T get() throws EntryProcessorException {
                        return result;
                    }
                });
            }
            catch (EntryProcessorException e) {
                results.put(key, new EntryProcessorResult<T>(){

                    @Override
                    public T get() throws EntryProcessorException {
                        throw e;
                    }
                });
            }
        }
        return results;
    }

    @Override
    public CacheManager getCacheManager() {
        this.checkNotClosed();
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        JCacheManager jCacheManager = this.cacheManager;
        synchronized (jCacheManager) {
            if (!this.isClosed()) {
                if (this.hasOwnRedisson) {
                    this.redisson.shutdown();
                }
                this.cacheManager.closeCache(this);
                for (CacheEntryListenerConfiguration config : this.listeners.keySet()) {
                    this.deregisterCacheEntryListener(config);
                }
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    private void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        int listenerId;
        RTopic<List<Object>> topic;
        String channelName;
        Factory<CacheEntryListener<K, V>> factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        final CacheEntryListener<K, V> listener = factory.create();
        Factory<CacheEntryEventFilter<K, V>> filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        final CacheEntryEventFilter<K, V> filter = filterFactory != null ? filterFactory.create() : null;
        Map<Integer, String> values = new ConcurrentHashMap();
        Map oldValues = this.listeners.putIfAbsent(cacheEntryListenerConfiguration, values);
        if (oldValues != null) {
            values = oldValues;
        }
        final boolean sync = cacheEntryListenerConfiguration.isSynchronous();
        if (CacheEntryRemovedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getRemovedChannelName();
            if (sync) {
                channelName = this.getRemovedSyncChannelName();
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, sync));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.REMOVED, msg.get(0), msg.get(1));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryRemovedListener)listener).onRemoved(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryCreatedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getCreatedChannelName();
            if (sync) {
                channelName = this.getCreatedSyncChannelName();
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, sync));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.CREATED, msg.get(0), msg.get(1));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryCreatedListener)listener).onCreated(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryUpdatedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getUpdatedChannelName();
            if (sync) {
                channelName = this.getUpdatedSyncChannelName();
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, sync));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.UPDATED, msg.get(0), msg.get(1));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryUpdatedListener)listener).onUpdated(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryExpiredListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getExpiredChannelName();
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, false));
            listenerId = topic.addListener(new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.EXPIRED, msg.get(0), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryExpiredListener)listener).onExpired(events);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (addToConfig) {
            this.config.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
    }

    private void sendSync(boolean sync, List<Object> msg) {
        if (sync) {
            RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(msg.get(2)));
            semaphore.release();
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Map listenerIds = (Map)this.listeners.remove(cacheEntryListenerConfiguration);
        if (listenerIds != null) {
            for (Map.Entry entry : listenerIds.entrySet()) {
                this.redisson.getTopic((String)entry.getValue()).removeListener((Integer)entry.getKey());
            }
        }
        this.config.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNotClosed();
        return new RedissonBaseMapIterator<Cache.Entry<K, V>>(){

            @Override
            protected Cache.Entry<K, V> getValue(Map.Entry<Object, Object> entry) {
                JCache.this.cacheManager.getStatBean(JCache.this).addHits(1L);
                Long accessTimeout = JCache.this.getAccessTimeout();
                JCacheEntry<Object, Object> je = new JCacheEntry<Object, Object>(entry.getKey(), entry.getValue());
                if (accessTimeout == 0L) {
                    this.remove();
                } else if (accessTimeout != -1L) {
                    JCache.this.write(JCache.this.getName(), RedisCommands.ZADD_BOOL, new Object[]{JCache.this.getTimeoutSetName(), accessTimeout, JCache.this.encodeMapKey(entry.getKey())});
                }
                return je;
            }

            @Override
            protected void remove(Map.Entry<Object, Object> entry) {
                JCache.this.remove(entry.getKey());
            }

            @Override
            protected Object put(Map.Entry<Object, Object> entry, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, long nextIterPos) {
                return JCache.this.scanIterator(JCache.this.getName(), client, nextIterPos);
            }
        };
    }
}

