/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import reactor.core.reactivestreams.PublisherFactory;
import reactor.core.reactivestreams.SubscriberWithContext;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.rx.Stream;
import reactor.rx.Streams;

public final class RangeStream {
    public static Stream<Long> create(final long min, final long max) {
        return Streams.wrap(PublisherFactory.forEach(new Consumer<SubscriberWithContext<Long, Range>>(){

            @Override
            public void accept(SubscriberWithContext<Long, Range> subscriber) {
                Range range = subscriber.context();
                if (range.cursor <= range.end) {
                    subscriber.onNext(range.cursor++);
                }
                if (range.cursor > range.end) {
                    subscriber.onComplete();
                }
            }
        }, new Function<Subscriber<? super Long>, Range>(){

            @Override
            public Range apply(Subscriber<? super Long> subscriber) {
                if (max < min) {
                    subscriber.onComplete();
                    throw PublisherFactory.PrematureCompleteException.INSTANCE;
                }
                return new Range(min, max);
            }
        }));
    }

    private static final class Range {
        final long start;
        final long end;
        long cursor;

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
            this.cursor = start;
        }

        public String toString() {
            return "{cursor=" + this.cursor + "" + (this.end > 0L ? "[" + 100L * (this.cursor - 1L) / this.end + "%]" : "") + ", start=" + this.start + ", end=" + this.end + "}";
        }
    }
}

