/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSet;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class AddOperation
extends TransactionalOperation {
    private Object value;

    public AddOperation(RObject set, Object value) {
        this(set.getName(), set.getCodec(), value);
    }

    public AddOperation(String name, Codec codec, Object value) {
        super(name, codec);
        this.value = value;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSet<Object> set = new RedissonSet<Object>(this.codec, commandExecutor, this.name, null);
        set.addAsync(this.value);
        set.getLock(this.value).unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSet<Object> set = new RedissonSet<Object>(this.codec, commandExecutor, this.name, null);
        set.getLock(this.value).unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }
}

