/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.processor.InsufficientCapacityException;

public abstract class MultiThreadDispatcher
extends AbstractLifecycleDispatcher {
    private final int backlog;
    private final int numberThreads;

    protected MultiThreadDispatcher(int numberThreads, int backlog) {
        this.backlog = backlog;
        this.numberThreads = numberThreads;
    }

    @Override
    public boolean supportsOrdering() {
        return false;
    }

    @Override
    public long backlogSize() {
        return this.backlog;
    }

    public int poolSize() {
        return this.numberThreads;
    }

    @Override
    protected void scheduleLater(AbstractLifecycleDispatcher.Task task) {
        this.execute(task);
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateRecursiveTask() {
        return this.allocateTask();
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateTask() {
        return new MultiThreadTask();
    }

    @Override
    protected AbstractLifecycleDispatcher.Task tryAllocateTask() throws InsufficientCapacityException {
        return this.allocateTask();
    }

    protected class MultiThreadTask
    extends AbstractLifecycleDispatcher.Task {
        protected MultiThreadTask() {
            super(MultiThreadDispatcher.this);
        }

        @Override
        public void run() {
            AbstractLifecycleDispatcher.route(this);
        }
    }
}

