/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import java.util.Collections;
import java.util.List;

public class RemoteServiceKey {
    private final Class<?> serviceInterface;
    private final String methodName;
    private final List<String> signatures;

    public RemoteServiceKey(Class<?> serviceInterface, String method, List<String> signatures) {
        this.serviceInterface = serviceInterface;
        this.methodName = method;
        this.signatures = Collections.unmodifiableList(signatures);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.signatures == null ? 0 : this.signatures.hashCode());
        result = 31 * result + (this.serviceInterface == null ? 0 : this.serviceInterface.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServiceKey other = (RemoteServiceKey)obj;
        if (this.methodName == null) {
            if (other.methodName != null) {
                return false;
            }
        } else {
            if (!this.methodName.equals(other.methodName)) {
                return false;
            }
            if (!this.signatures.equals(other.signatures)) {
                return false;
            }
        }
        return !(this.serviceInterface == null ? other.serviceInterface != null : !this.serviceInterface.equals(other.serviceInterface));
    }
}

