/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.ArrayList;
import java.util.List;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.RPromise;

public class CommandsData
implements QueueCommand {
    private final List<CommandData<?, ?>> commands;
    private final List<CommandData<?, ?>> attachedCommands;
    private final RPromise<Void> promise;
    private final boolean skipResult;
    private final boolean atomic;
    private final boolean queued;

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands, boolean queued) {
        this(promise, commands, null, false, false, queued);
    }

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands, List<CommandData<?, ?>> attachedCommands) {
        this(promise, commands, attachedCommands, false, false, true);
    }

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands, boolean skipResult, boolean atomic, boolean queued) {
        this(promise, commands, null, skipResult, atomic, queued);
    }

    public CommandsData(RPromise<Void> promise, List<CommandData<?, ?>> commands, List<CommandData<?, ?>> attachedCommands, boolean skipResult, boolean atomic, boolean queued) {
        this.promise = promise;
        this.commands = commands;
        this.skipResult = skipResult;
        this.atomic = atomic;
        this.attachedCommands = attachedCommands;
        this.queued = queued;
    }

    public RPromise<Void> getPromise() {
        return this.promise;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isSkipResult() {
        return this.skipResult;
    }

    public List<CommandData<?, ?>> getAttachedCommands() {
        return this.attachedCommands;
    }

    public List<CommandData<?, ?>> getCommands() {
        return this.commands;
    }

    @Override
    public List<CommandData<Object, Object>> getPubSubOperations() {
        ArrayList<CommandData<Object, Object>> result = new ArrayList<CommandData<Object, Object>>();
        for (CommandData<?, ?> commandData : this.commands) {
            if (!RedisCommands.PUBSUB_COMMANDS.equals(commandData.getCommand().getName())) continue;
            result.add(commandData);
        }
        return result;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }

    public String toString() {
        return "CommandsData [commands=" + this.commands + "]";
    }

    @Override
    public boolean isExecuted() {
        return this.promise.isDone();
    }
}

