/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Collection;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.RFuture;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScoredSortedSetAsync;
import org.redisson.api.RScoredSortedSetReactive;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;
import reactor.fn.Supplier;

public class RedissonScoredSortedSetReactive<V>
extends RedissonExpirableReactive
implements RScoredSortedSetReactive<V> {
    private final RScoredSortedSetAsync<V> instance;

    public RedissonScoredSortedSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor, name, new RedissonScoredSortedSet(commandExecutor, name, null));
    }

    public RedissonScoredSortedSetReactive(CommandReactiveExecutor commandExecutor, String name, RScoredSortedSetAsync<V> instance) {
        super(commandExecutor, name, instance);
        this.instance = instance;
    }

    public RedissonScoredSortedSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this(codec, commandExecutor, name, new RedissonScoredSortedSet(codec, commandExecutor, name, null));
    }

    public RedissonScoredSortedSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, RScoredSortedSetAsync<V> instance) {
        super(codec, commandExecutor, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<V> pollFirst() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonScoredSortedSetReactive.this.instance.pollFirstAsync();
            }
        });
    }

    @Override
    public Publisher<V> pollLast() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonScoredSortedSetReactive.this.instance.pollLastAsync();
            }
        });
    }

    @Override
    public Publisher<V> first() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonScoredSortedSetReactive.this.instance.firstAsync();
            }
        });
    }

    @Override
    public Publisher<V> last() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonScoredSortedSetReactive.this.instance.lastAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> add(final double score, final V object) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.addAsync(score, object);
            }
        });
    }

    @Override
    public Publisher<Integer> removeRangeByRank(final int startIndex, final int endIndex) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.removeRangeByRankAsync(startIndex, endIndex);
            }
        });
    }

    @Override
    public Publisher<Integer> removeRangeByScore(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.removeRangeByScoreAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final V object) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.removeAsync(object);
            }
        });
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> contains(final V o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.containsAsync(o);
            }
        });
    }

    @Override
    public Publisher<Double> getScore(final V o) {
        return this.reactive(new Supplier<RFuture<Double>>(){

            @Override
            public RFuture<Double> get() {
                return RedissonScoredSortedSetReactive.this.instance.getScoreAsync(o);
            }
        });
    }

    @Override
    public Publisher<Integer> rank(final V o) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.rankAsync(o);
            }
        });
    }

    private Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), new ScanCodec(this.codec), RedisCommands.ZSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<V> iterator() {
        return new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient client, long nextIterPos) {
                return RedissonScoredSortedSetReactive.this.scanIteratorReactive(client, nextIterPos);
            }
        };
    }

    @Override
    public Publisher<Boolean> containsAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.containsAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> removeAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.removeAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> retainAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonScoredSortedSetReactive.this.instance.retainAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Double> addScore(final V object, final Number value) {
        return this.reactive(new Supplier<RFuture<Double>>(){

            @Override
            public RFuture<Double> get() {
                return RedissonScoredSortedSetReactive.this.instance.addScoreAsync(object, value);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRange(final int startIndex, final int endIndex) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeAsync(startIndex, endIndex);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(final int startIndex, final int endIndex) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeAsync(startIndex, endIndex);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRange(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRange(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRange(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count);
            }
        });
    }

    @Override
    public Publisher<Long> count(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonScoredSortedSetReactive.this.instance.countAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> readAll() {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.readAllAsync();
            }
        });
    }

    @Override
    public Publisher<Integer> intersection(final String ... names) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.intersectionAsync(names);
            }
        });
    }

    @Override
    public Publisher<Integer> intersection(final RScoredSortedSet.Aggregate aggregate, final String ... names) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.intersectionAsync(aggregate, names);
            }
        });
    }

    @Override
    public Publisher<Integer> intersection(final Map<String, Double> nameWithWeight) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.intersectionAsync(nameWithWeight);
            }
        });
    }

    @Override
    public Publisher<Integer> intersection(final RScoredSortedSet.Aggregate aggregate, final Map<String, Double> nameWithWeight) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.intersectionAsync(aggregate, nameWithWeight);
            }
        });
    }

    @Override
    public Publisher<Integer> union(final String ... names) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.unionAsync(names);
            }
        });
    }

    @Override
    public Publisher<Integer> union(final RScoredSortedSet.Aggregate aggregate, final String ... names) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.unionAsync(aggregate, names);
            }
        });
    }

    @Override
    public Publisher<Integer> union(final Map<String, Double> nameWithWeight) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.unionAsync(nameWithWeight);
            }
        });
    }

    @Override
    public Publisher<Integer> union(final RScoredSortedSet.Aggregate aggregate, final Map<String, Double> nameWithWeight) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonScoredSortedSetReactive.this.instance.unionAsync(aggregate, nameWithWeight);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRangeReversed(final int startIndex, final int endIndex) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeReversedAsync(startIndex, endIndex);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRangeReversed(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Collection<V>> valueRangeReversed(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Collection<V>>>(){

            @Override
            public RFuture<Collection<V>> get() {
                return RedissonScoredSortedSetReactive.this.instance.valueRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRangeReversed(final int startIndex, final int endIndex) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeReversedAsync(startIndex, endIndex);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRangeReversed(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive);
            }
        });
    }

    @Override
    public Publisher<Collection<ScoredEntry<V>>> entryRangeReversed(final double startScore, final boolean startScoreInclusive, final double endScore, final boolean endScoreInclusive, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Collection<ScoredEntry<V>>>>(){

            @Override
            public RFuture<Collection<ScoredEntry<V>>> get() {
                return RedissonScoredSortedSetReactive.this.instance.entryRangeReversedAsync(startScore, startScoreInclusive, endScore, endScoreInclusive, offset, count);
            }
        });
    }
}

