/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.PubSubEntry;
import org.redisson.client.handler.PubSubKey;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;

public class CommandPubSubDecoder
extends CommandDecoder {
    private final Map<String, PubSubEntry> entries = new HashMap<String, PubSubEntry>();
    private final Map<PubSubKey, CommandData<Object, Object>> commands = PlatformDependent.newConcurrentHashMap();
    private final ExecutorService executor;
    private final boolean keepOrder;

    public CommandPubSubDecoder(ExecutorService executor, boolean keepOrder) {
        this.executor = executor;
        this.keepOrder = keepOrder;
    }

    public void addPubSubCommand(String channel, CommandData<Object, Object> data) {
        String operation = data.getCommand().getName().toLowerCase();
        this.commands.put(new PubSubKey(channel, operation), data);
    }

    @Override
    protected void decodeResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, final Object result) throws IOException {
        super.decodeResult(data, parts, channel, result);
        if (result instanceof Message) {
            this.checkpoint();
            final RedisPubSubConnection pubSubConnection = (RedisPubSubConnection)RedisPubSubConnection.getFrom(channel);
            String channelName = ((Message)result).getChannel();
            if (result instanceof PubSubStatusMessage) {
                String operation = ((PubSubStatusMessage)result).getType().name().toLowerCase();
                PubSubKey key = new PubSubKey(channelName, operation);
                CommandData<Object, Object> d = this.commands.get(key);
                if (Arrays.asList(RedisCommands.PSUBSCRIBE.getName(), RedisCommands.SUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    this.entries.put(channelName, new PubSubEntry(d.getMessageDecoder()));
                }
                if (Arrays.asList(RedisCommands.PUNSUBSCRIBE.getName(), RedisCommands.UNSUBSCRIBE.getName()).contains(d.getCommand().getName())) {
                    this.commands.remove(key);
                    if (result instanceof PubSubPatternMessage) {
                        channelName = ((PubSubPatternMessage)result).getPattern();
                    }
                    PubSubEntry entry = this.entries.remove(channelName);
                    if (this.keepOrder) {
                        this.enqueueMessage(result, pubSubConnection, entry);
                    }
                }
            }
            if (this.keepOrder) {
                PubSubEntry entry;
                if (result instanceof PubSubPatternMessage) {
                    channelName = ((PubSubPatternMessage)result).getPattern();
                }
                if ((entry = this.entries.get(channelName)) != null) {
                    this.enqueueMessage(result, pubSubConnection, entry);
                }
            } else {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (result instanceof PubSubStatusMessage) {
                            pubSubConnection.onMessage((PubSubStatusMessage)result);
                        } else if (result instanceof PubSubMessage) {
                            pubSubConnection.onMessage((PubSubMessage)result);
                        } else {
                            pubSubConnection.onMessage((PubSubPatternMessage)result);
                        }
                    }
                });
            }
        }
    }

    private void enqueueMessage(Object result, final RedisPubSubConnection pubSubConnection, final PubSubEntry entry) {
        if (result != null) {
            entry.getQueue().add((Message)result);
        }
        if (entry.getSent().compareAndSet(false, true)) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Message result;
                        while ((result = entry.getQueue().poll()) != null) {
                            if (result instanceof PubSubStatusMessage) {
                                pubSubConnection.onMessage((PubSubStatusMessage)result);
                                continue;
                            }
                            if (result instanceof PubSubMessage) {
                                pubSubConnection.onMessage((PubSubMessage)result);
                                continue;
                            }
                            pubSubConnection.onMessage((PubSubPatternMessage)result);
                        }
                    }
                    finally {
                        entry.getSent().set(false);
                        if (!entry.getQueue().isEmpty()) {
                            CommandPubSubDecoder.this.enqueueMessage(null, pubSubConnection, entry);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null) {
            if (parts.isEmpty()) {
                return null;
            }
            String command = parts.get(0).toString();
            if (Arrays.asList("subscribe", "psubscribe", "punsubscribe", "unsubscribe").contains(command)) {
                String channelName = parts.get(1).toString();
                PubSubKey key = new PubSubKey(channelName, command);
                CommandData<Object, Object> commandData = this.commands.get(key);
                if (commandData == null) {
                    return null;
                }
                return commandData.getCommand().getReplayMultiDecoder();
            }
            if (command.equals("message")) {
                String channelName = (String)parts.get(1);
                return this.entries.get(channelName).getDecoder();
            }
            if (command.equals("pmessage")) {
                String patternName = (String)parts.get(1);
                return this.entries.get(patternName).getDecoder();
            }
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    @Override
    protected Decoder<Object> selectDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null && parts != null) {
            if (parts.size() == 2 && "message".equals(parts.get(0))) {
                String channelName = (String)parts.get(1);
                return this.entries.get(channelName).getDecoder().getDecoder(parts.size(), (State)this.state());
            }
            if (parts.size() == 3 && "pmessage".equals(parts.get(0))) {
                String patternName = (String)parts.get(1);
                return this.entries.get(patternName).getDecoder().getDecoder(parts.size(), (State)this.state());
            }
        }
        if (data != null && data.getCommand().getName().equals(RedisCommands.PING.getName())) {
            return data.getCodec().getValueDecoder();
        }
        return super.selectDecoder(data, parts);
    }
}

