/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonBatch;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonObject;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMultimapAsync;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RTopic;
import org.redisson.api.RTopicAsync;
import org.redisson.api.RTransaction;
import org.redisson.api.TransactionOptions;
import org.redisson.api.listener.MessageListener;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisabledKey;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.HashKey;
import org.redisson.transaction.HashValue;
import org.redisson.transaction.RedissonTransactionalBucket;
import org.redisson.transaction.RedissonTransactionalLocalCachedMap;
import org.redisson.transaction.RedissonTransactionalMap;
import org.redisson.transaction.RedissonTransactionalMapCache;
import org.redisson.transaction.RedissonTransactionalSet;
import org.redisson.transaction.RedissonTransactionalSetCache;
import org.redisson.transaction.TransactionException;
import org.redisson.transaction.TransactionTimeoutException;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.map.MapOperation;

public class RedissonTransaction
implements RTransaction {
    private final CommandAsyncExecutor commandExecutor;
    private final AtomicBoolean executed = new AtomicBoolean();
    private final TransactionOptions options;
    private List<TransactionalOperation> operations = new ArrayList<TransactionalOperation>();
    private Set<String> localCaches = new HashSet<String>();
    private final long startTime = System.currentTimeMillis();

    public RedissonTransaction(CommandAsyncExecutor commandExecutor, TransactionOptions options) {
        this.options = options;
        this.commandExecutor = commandExecutor;
    }

    public RedissonTransaction(CommandAsyncExecutor commandExecutor, TransactionOptions options, List<TransactionalOperation> operations, Set<String> localCaches) {
        this.commandExecutor = commandExecutor;
        this.options = options;
        this.operations = operations;
        this.localCaches = localCaches;
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(RLocalCachedMap<K, V> fromInstance) {
        this.checkState();
        this.localCaches.add(fromInstance.getName());
        return new RedissonTransactionalLocalCachedMap<K, V>(this.commandExecutor, this.operations, this.options.getTimeout(), this.executed, fromInstance);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        this.checkState();
        return new RedissonTransactionalBucket(this.commandExecutor, name, this.operations, this.executed);
    }

    @Override
    public <V> RBucket<V> getBucket(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalBucket(codec, this.commandExecutor, name, this.operations, this.executed);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        this.checkState();
        return new RedissonTransactionalSet(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <V> RSet<V> getSet(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalSet(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name) {
        this.checkState();
        return new RedissonTransactionalSetCache(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalSetCache(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        this.checkState();
        return new RedissonTransactionalMap(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalMap(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name) {
        this.checkState();
        return new RedissonTransactionalMapCache(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalMapCache(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed);
    }

    @Override
    public RFuture<Void> commitAsync() {
        this.checkState();
        this.checkTimeout();
        final CommandBatchService transactionExecutor = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (TransactionalOperation transactionalOperation : this.operations) {
            transactionalOperation.commit(transactionExecutor);
        }
        final String id = RedissonTransaction.generateId();
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Map<HashKey, HashValue>> future = this.disableLocalCacheAsync(id, this.localCaches, this.operations);
        future.addListener(new FutureListener<Map<HashKey, HashValue>>(){

            @Override
            public void operationComplete(Future<Map<HashKey, HashValue>> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(new TransactionException("Unable to execute transaction", future.cause()));
                    return;
                }
                final Map<HashKey, HashValue> hashes = future.getNow();
                try {
                    RedissonTransaction.this.checkTimeout();
                }
                catch (TransactionTimeoutException e) {
                    RedissonTransaction.this.enableLocalCacheAsync(id, hashes);
                    result.tryFailure(e);
                    return;
                }
                int syncSlaves = 0;
                if (!RedissonTransaction.this.commandExecutor.getConnectionManager().isClusterMode()) {
                    MasterSlaveEntry entry = RedissonTransaction.this.commandExecutor.getConnectionManager().getEntrySet().iterator().next();
                    syncSlaves = entry.getAvailableClients() - 1;
                }
                BatchOptions batchOptions = BatchOptions.defaults().syncSlaves(syncSlaves, RedissonTransaction.this.options.getSyncTimeout(), TimeUnit.MILLISECONDS).responseTimeout(RedissonTransaction.this.options.getResponseTimeout(), TimeUnit.MILLISECONDS).retryAttempts(RedissonTransaction.this.options.getRetryAttempts()).retryInterval(RedissonTransaction.this.options.getRetryInterval(), TimeUnit.MILLISECONDS).atomic();
                RFuture transactionFuture = transactionExecutor.executeAsync(batchOptions);
                transactionFuture.addListener(new FutureListener<Object>(){

                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(new TransactionException("Unable to execute transaction", future.cause()));
                            return;
                        }
                        RedissonTransaction.this.enableLocalCacheAsync(id, hashes);
                        RedissonTransaction.this.executed.set(true);
                        result.trySuccess(null);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public void commit() {
        this.commit(this.localCaches, this.operations);
    }

    public void commit(Set<String> localCaches, List<TransactionalOperation> operations) {
        this.checkState();
        this.checkTimeout();
        CommandBatchService transactionExecutor = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (TransactionalOperation transactionalOperation : operations) {
            transactionalOperation.commit(transactionExecutor);
        }
        String id = RedissonTransaction.generateId();
        Map<HashKey, HashValue> hashes = this.disableLocalCache(id, localCaches, operations);
        try {
            this.checkTimeout();
        }
        catch (TransactionTimeoutException e) {
            this.enableLocalCache(id, hashes);
            throw e;
        }
        int syncSlaves = 0;
        if (!this.commandExecutor.getConnectionManager().isClusterMode()) {
            MasterSlaveEntry entry = this.commandExecutor.getConnectionManager().getEntrySet().iterator().next();
            syncSlaves = entry.getAvailableClients() - 1;
        }
        try {
            BatchOptions batchOptions = BatchOptions.defaults().syncSlaves(syncSlaves, this.options.getSyncTimeout(), TimeUnit.MILLISECONDS).responseTimeout(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS).retryAttempts(this.options.getRetryAttempts()).retryInterval(this.options.getRetryInterval(), TimeUnit.MILLISECONDS).atomic();
            transactionExecutor.execute(batchOptions);
        }
        catch (Exception e) {
            throw new TransactionException("Unable to execute transaction", e);
        }
        this.enableLocalCache(id, hashes);
        this.executed.set(true);
    }

    private void checkTimeout() {
        if (this.options.getTimeout() != -1L && System.currentTimeMillis() - this.startTime > this.options.getTimeout()) {
            throw new TransactionTimeoutException("Transaction was discarded due to timeout " + this.options.getTimeout() + " milliseconds");
        }
    }

    private RFuture<BatchResult<?>> enableLocalCacheAsync(String requestId, Map<HashKey, HashValue> hashes) {
        if (hashes.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedissonBatch publishBatch = new RedissonBatch(null, this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
        for (Map.Entry<HashKey, HashValue> entry : hashes.entrySet()) {
            String name = RedissonObject.suffixName(entry.getKey().getName(), "topic");
            RTopicAsync<LocalCachedMapEnable> topic = publishBatch.getTopic(name, LocalCachedMessageCodec.INSTANCE);
            LocalCachedMapEnable msg = new LocalCachedMapEnable(requestId, (byte[][])entry.getValue().getKeyIds().toArray((T[])new byte[entry.getValue().getKeyIds().size()][]));
            topic.publishAsync(msg);
        }
        return publishBatch.executeAsync();
    }

    private void enableLocalCache(String requestId, Map<HashKey, HashValue> hashes) {
        if (hashes.isEmpty()) {
            return;
        }
        RedissonBatch publishBatch = new RedissonBatch(null, this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
        for (Map.Entry<HashKey, HashValue> entry : hashes.entrySet()) {
            String name = RedissonObject.suffixName(entry.getKey().getName(), "topic");
            RTopicAsync<LocalCachedMapEnable> topic = publishBatch.getTopic(name, LocalCachedMessageCodec.INSTANCE);
            LocalCachedMapEnable msg = new LocalCachedMapEnable(requestId, (byte[][])entry.getValue().getKeyIds().toArray((T[])new byte[entry.getValue().getKeyIds().size()][]));
            topic.publishAsync(msg);
        }
        try {
            publishBatch.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<HashKey, HashValue> disableLocalCache(String requestId, Set<String> localCaches, List<TransactionalOperation> operations) {
        if (localCaches.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<HashKey, HashValue> hashes = new HashMap<HashKey, HashValue>(localCaches.size());
        RedissonBatch batch = new RedissonBatch(null, this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
        for (TransactionalOperation transactionalOperation : operations) {
            if (!localCaches.contains(transactionalOperation.getName())) continue;
            MapOperation mapOperation = (MapOperation)transactionalOperation;
            RedissonLocalCachedMap redissonLocalCachedMap = (RedissonLocalCachedMap)mapOperation.getMap();
            HashKey hashKey = new HashKey(transactionalOperation.getName(), transactionalOperation.getCodec());
            byte[] key = redissonLocalCachedMap.toCacheKey(mapOperation.getKey()).getKeyHash();
            HashValue value = (HashValue)hashes.get(hashKey);
            if (value == null) {
                value = new HashValue();
                hashes.put(hashKey, value);
            }
            value.getKeyIds().add(key);
            String disabledKeysName = RedissonObject.suffixName(transactionalOperation.getName(), "disabled-keys");
            RMultimapAsync multimap = batch.getListMultimapCache(disabledKeysName, transactionalOperation.getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.putAsync(localCacheKey, ByteBufUtil.hexDump(key));
            multimap.expireKeyAsync(localCacheKey, this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        try {
            batch.execute();
        }
        catch (Exception e) {
            throw new TransactionException("Unable to execute transaction over local cached map objects: " + localCaches, e);
        }
        final CountDownLatch latch = new CountDownLatch(hashes.size());
        ArrayList topics = new ArrayList();
        for (final Map.Entry entry : hashes.entrySet()) {
            RedissonTopic<Object> redissonTopic = new RedissonTopic<Object>(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), requestId + ":topic"));
            topics.add(redissonTopic);
            redissonTopic.addListener(new MessageListener<Object>(){

                @Override
                public void onMessage(String channel, Object msg) {
                    AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                    if (counter.decrementAndGet() == 0) {
                        latch.countDown();
                    }
                }
            });
        }
        RedissonBatch publishBatch = new RedissonBatch(null, this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
        for (final Map.Entry entry : hashes.entrySet()) {
            String disabledKeysName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "disabled-keys");
            RMultimapAsync multimap = publishBatch.getListMultimapCache(disabledKeysName, ((HashKey)entry.getKey()).getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.removeAllAsync(localCacheKey);
            RTopicAsync<LocalCachedMapDisable> topic = publishBatch.getTopic(RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "topic"), LocalCachedMessageCodec.INSTANCE);
            RFuture<Long> future = topic.publishAsync(new LocalCachedMapDisable(requestId, (byte[][])((HashValue)entry.getValue()).getKeyIds().toArray((T[])new byte[((HashValue)entry.getValue()).getKeyIds().size()][]), this.options.getResponseTimeout()));
            future.addListener(new FutureListener<Long>(){

                @Override
                public void operationComplete(Future<Long> future) throws Exception {
                    if (!future.isSuccess()) {
                        return;
                    }
                    int receivers = future.getNow().intValue();
                    AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                    if (counter.addAndGet(receivers) == 0) {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            publishBatch.execute();
        }
        catch (Exception exception) {
            throw new TransactionException("Unable to execute transaction over local cached map objects: " + localCaches, exception);
        }
        for (RTopic rTopic : topics) {
            rTopic.removeAllListeners();
        }
        try {
            latch.await(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return hashes;
    }

    private RFuture<Map<HashKey, HashValue>> disableLocalCacheAsync(final String requestId, Set<String> localCaches, List<TransactionalOperation> operations) {
        if (localCaches.isEmpty()) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        final RedissonPromise<Map<HashKey, HashValue>> result = new RedissonPromise<Map<HashKey, HashValue>>();
        final HashMap<HashKey, HashValue> hashes = new HashMap<HashKey, HashValue>(localCaches.size());
        RedissonBatch batch = new RedissonBatch(null, this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
        for (TransactionalOperation transactionalOperation : operations) {
            if (!localCaches.contains(transactionalOperation.getName())) continue;
            MapOperation mapOperation = (MapOperation)transactionalOperation;
            RedissonLocalCachedMap map = (RedissonLocalCachedMap)mapOperation.getMap();
            HashKey hashKey = new HashKey(transactionalOperation.getName(), transactionalOperation.getCodec());
            byte[] key = map.toCacheKey(mapOperation.getKey()).getKeyHash();
            HashValue value = (HashValue)hashes.get(hashKey);
            if (value == null) {
                value = new HashValue();
                hashes.put(hashKey, value);
            }
            value.getKeyIds().add(key);
            String disabledKeysName = RedissonObject.suffixName(transactionalOperation.getName(), "disabled-keys");
            RMultimapAsync multimap = batch.getListMultimapCache(disabledKeysName, transactionalOperation.getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.putAsync(localCacheKey, ByteBufUtil.hexDump(key));
            multimap.expireKeyAsync(localCacheKey, this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        RFuture<BatchResult<?>> batchListener = batch.executeAsync();
        batchListener.addListener(new FutureListener<BatchResult<?>>(){

            @Override
            public void operationComplete(Future<BatchResult<?>> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                final CountableListener<Map> listener = new CountableListener<Map>(result, hashes);
                listener.setCounter(hashes.size());
                RedissonPromise<Void> subscriptionFuture = new RedissonPromise<Void>();
                final CountableListener<Object> subscribedFutures = new CountableListener<Object>(subscriptionFuture, null);
                subscribedFutures.setCounter(hashes.size());
                final ArrayList topics = new ArrayList();
                for (final Map.Entry entry : hashes.entrySet()) {
                    String disabledAckName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), requestId + ":topic");
                    RedissonTopic<Object> topic = new RedissonTopic<Object>(LocalCachedMessageCodec.INSTANCE, RedissonTransaction.this.commandExecutor, disabledAckName);
                    topics.add(topic);
                    RFuture<Integer> topicFuture = topic.addListenerAsync(new MessageListener<Object>(){

                        @Override
                        public void onMessage(String channel, Object msg) {
                            AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                            if (counter.decrementAndGet() == 0) {
                                listener.decCounter();
                            }
                        }
                    });
                    topicFuture.addListener(new FutureListener<Integer>(){

                        @Override
                        public void operationComplete(Future<Integer> future) throws Exception {
                            subscribedFutures.decCounter();
                        }
                    });
                }
                subscriptionFuture.addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        RedissonBatch publishBatch = new RedissonBatch(null, RedissonTransaction.this.commandExecutor.getConnectionManager(), BatchOptions.defaults());
                        for (final Map.Entry entry : hashes.entrySet()) {
                            String disabledKeysName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "disabled-keys");
                            RMultimapAsync multimap = publishBatch.getListMultimapCache(disabledKeysName, ((HashKey)entry.getKey()).getCodec());
                            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, RedissonTransaction.this.options.getResponseTimeout());
                            multimap.removeAllAsync(localCacheKey);
                            RTopicAsync<LocalCachedMapDisable> topic = publishBatch.getTopic(RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "topic"), LocalCachedMessageCodec.INSTANCE);
                            RFuture<Long> publishFuture = topic.publishAsync(new LocalCachedMapDisable(requestId, (byte[][])((HashValue)entry.getValue()).getKeyIds().toArray((T[])new byte[((HashValue)entry.getValue()).getKeyIds().size()][]), RedissonTransaction.this.options.getResponseTimeout()));
                            publishFuture.addListener(new FutureListener<Long>(){

                                @Override
                                public void operationComplete(Future<Long> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        return;
                                    }
                                    int receivers = future.getNow().intValue();
                                    AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                                    if (counter.addAndGet(receivers) == 0) {
                                        listener.decCounter();
                                    }
                                }
                            });
                        }
                        RFuture<BatchResult<?>> publishFuture = publishBatch.executeAsync();
                        publishFuture.addListener(new FutureListener<BatchResult<?>>(){

                            @Override
                            public void operationComplete(Future<BatchResult<?>> future) throws Exception {
                                result.addListener(new FutureListener<Map<HashKey, HashValue>>(){

                                    @Override
                                    public void operationComplete(Future<Map<HashKey, HashValue>> future) throws Exception {
                                        for (RTopic topic : topics) {
                                            topic.removeAllListeners();
                                        }
                                    }
                                });
                                if (!future.isSuccess()) {
                                    result.tryFailure(future.cause());
                                    return;
                                }
                                RedissonTransaction.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                    @Override
                                    public void run(Timeout timeout) throws Exception {
                                        result.tryFailure(new TransactionTimeoutException("Unable to execute transaction within " + RedissonTransaction.this.options.getResponseTimeout() + "ms"));
                                    }
                                }, RedissonTransaction.this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    protected static String generateId() {
        byte[] id = new byte[16];
        PlatformDependent.threadLocalRandom().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    @Override
    public void rollback() {
        this.rollback(this.operations);
    }

    public void rollback(List<TransactionalOperation> operations) {
        this.checkState();
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (TransactionalOperation transactionalOperation : operations) {
            transactionalOperation.rollback(executorService);
        }
        try {
            executorService.execute(BatchOptions.defaults());
        }
        catch (Exception e) {
            throw new TransactionException("Unable to rollback transaction", e);
        }
        operations.clear();
        this.executed.set(true);
    }

    @Override
    public RFuture<Void> rollbackAsync() {
        this.checkState();
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (TransactionalOperation transactionalOperation : this.operations) {
            transactionalOperation.rollback(executorService);
        }
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture future = executorService.executeAsync(BatchOptions.defaults());
        future.addListener(new FutureListener<Object>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(new TransactionException("Unable to rollback transaction", future.cause()));
                    return;
                }
                RedissonTransaction.this.operations.clear();
                RedissonTransaction.this.executed.set(true);
                result.trySuccess(null);
            }
        });
        return result;
    }

    public Set<String> getLocalCaches() {
        return this.localCaches;
    }

    public List<TransactionalOperation> getOperations() {
        return this.operations;
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction was finished!");
        }
    }
}

