/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.api.RListAsync;
import org.redisson.api.RListReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.LongReplayConvertor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.Streams;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonListReactive<V>
extends RedissonExpirableReactive
implements RListReactive<V> {
    private final RListAsync<V> instance;

    public RedissonListReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name, new RedissonList(commandExecutor, name, null));
        this.instance = (RListAsync)((RedissonExpirableReactive)this).instance;
    }

    public RedissonListReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name, new RedissonList(codec, commandExecutor, name, null));
        this.instance = (RListAsync)((RedissonExpirableReactive)this).instance;
    }

    @Override
    public Publisher<Integer> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.LLEN_INT, this.getName());
    }

    @Override
    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    @Override
    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    @Override
    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    @Override
    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        return new Stream<V>(){

            @Override
            public void subscribe(Subscriber<? super V> t) {
                t.onSubscribe(new ReactiveSubscription<V>(this, t){
                    private int currentIndex;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    protected void onRequest(final long n) {
                        final 1 m = this;
                        RedissonListReactive.this.get(this.currentIndex).subscribe(new Subscriber<V>(){
                            V currValue;

                            @Override
                            public void onSubscribe(Subscription s) {
                                s.request(Long.MAX_VALUE);
                            }

                            @Override
                            public void onNext(V value) {
                                this.currValue = value;
                                m.onNext(value);
                                if (forward) {
                                    currentIndex++;
                                } else {
                                    currentIndex--;
                                }
                            }

                            @Override
                            public void onError(Throwable error) {
                                m.onError(error);
                            }

                            @Override
                            public void onComplete() {
                                if (this.currValue == null) {
                                    m.onComplete();
                                    return;
                                }
                                if (n - 1L == 0L) {
                                    return;
                                }
                                this.onRequest(n - 1L);
                            }
                        });
                    }
                });
            }
        };
    }

    @Override
    public Publisher<Integer> add(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPUSH, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<Boolean> remove(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonListReactive.this.instance.removeAsync(o);
            }
        });
    }

    protected Publisher<Boolean> remove(Object o, int count) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LREM_SINGLE, this.getName(), count, this.encode(o));
    }

    @Override
    public Publisher<Boolean> containsAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonListReactive.this.instance.containsAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this){

            @Override
            public Integer sum(Integer first, Integer second) {
                return second;
            }
        }.addAll(c);
    }

    @Override
    public Publisher<Integer> addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.size();
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getName());
        this.encode(args, c);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPUSH, args.toArray());
    }

    @Override
    public Publisher<Integer> addAll(long index, Collection<? extends V> coll) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (coll.isEmpty()) {
            return this.size();
        }
        if (index == 0L) {
            ArrayList<Object> elements = new ArrayList<Object>();
            this.encode(elements, coll);
            Collections.reverse(elements);
            elements.add(0, this.getName());
            return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LPUSH, elements.toArray());
        }
        ArrayList<Object> args = new ArrayList<Object>(coll.size() + 1);
        args.add(index);
        this.encode(args, coll);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local ind = table.remove(ARGV, 1); local size = redis.call('llen', KEYS[1]); assert(tonumber(ind) <= size, 'index: ' .. ind .. ' but current size: ' .. size); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i, v in ipairs(ARGV) do redis.call('rpush', KEYS[1], v) end;for i, v in ipairs(tail) do redis.call('rpush', KEYS[1], v) end;return redis.call('llen', KEYS[1]);", Collections.singletonList(this.getName()), args.toArray());
    }

    @Override
    public Publisher<Boolean> removeAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonListReactive.this.instance.removeAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> retainAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonListReactive.this.instance.retainAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<V> get(long index) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.LINDEX, this.getName(), index);
    }

    @Override
    public Publisher<V> set(long index, V element) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), index, this.encode(element));
    }

    @Override
    public Publisher<Void> fastSet(long index, V element) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LSET, this.getName(), index, this.encode(element));
    }

    @Override
    public Publisher<Integer> add(long index, V element) {
        return this.addAll(index, Collections.singleton(element));
    }

    @Override
    public Publisher<V> remove(final long index) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonListReactive.this.instance.removeAsync(index);
            }
        });
    }

    @Override
    public Publisher<Boolean> contains(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonListReactive.this.instance.containsAsync(o);
            }
        });
    }

    @Override
    public Publisher<Long> indexOf(final Object o) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return ((RedissonList)RedissonListReactive.this.instance).indexOfAsync(o, new LongReplayConvertor());
            }
        });
    }

    @Override
    public Publisher<Long> lastIndexOf(final Object o) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return ((RedissonList)RedissonListReactive.this.instance).lastIndexOfAsync(o, new LongReplayConvertor());
            }
        });
    }

    public boolean equals(Object o) {
        Stream<V> e2;
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonListReactive)) {
            return false;
        }
        Stream<V> e1 = Streams.wrap(this.iterator());
        Long count = Streams.merge(e1, e2 = Streams.wrap(((RedissonListReactive)o).iterator())).groupBy(new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        }).count().next().poll();
        boolean res = count.intValue() == Streams.wrap(this.size()).next().poll().intValue();
        return res &= count.intValue() == Streams.wrap(((RedissonListReactive)o).size()).next().poll().intValue();
    }

    public int hashCode() {
        Integer hash = Streams.wrap(this.iterator()).map(new Function<V, Integer>(){

            @Override
            public Integer apply(V t) {
                return t.hashCode();
            }
        }).reduce(1, new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return 31 * t + u;
            }
        }).next().poll();
        if (hash == null) {
            return 1;
        }
        return hash;
    }
}

