/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.misc.RPromise;

public class CountableListener<T>
implements FutureListener<Object> {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final RPromise<T> result;
    protected final T value;

    public CountableListener() {
        this(null, null);
    }

    public CountableListener(RPromise<T> result, T value) {
        this.result = result;
        this.value = value;
    }

    public void setCounter(int newValue) {
        this.counter.set(newValue);
    }

    public void incCounter() {
        this.counter.incrementAndGet();
    }

    public void decCounter() {
        if (this.counter.decrementAndGet() == 0) {
            this.onSuccess(this.value);
            if (this.result != null) {
                this.result.trySuccess(this.value);
            }
        }
    }

    @Override
    public void operationComplete(Future<Object> future) throws Exception {
        if (!future.isSuccess()) {
            if (this.result != null) {
                this.result.tryFailure(future.cause());
            }
            return;
        }
        this.decCounter();
    }

    protected void onSuccess(T value) {
    }
}

