/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.misc.HashValue;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public abstract class SetReactiveIterator<V>
extends Stream<V> {
    @Override
    public void subscribe(Subscriber<? super V> t) {
        t.onSubscribe(new ReactiveSubscription<V>(this, t){
            private List<HashValue> firstValues;
            private List<HashValue> lastValues;
            private long nextIterPos;
            private RedisClient client;
            private boolean finished;

            @Override
            protected void onRequest(long n) {
                this.nextValues();
            }

            private void handle(List<ScanObjectEntry> vals) {
                for (ScanObjectEntry val : vals) {
                    this.onNext(val.getObj());
                }
            }

            protected void nextValues() {
                final 1 m = this;
                SetReactiveIterator.this.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<ListScanResult<ScanObjectEntry>>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(ListScanResult<ScanObjectEntry> res) {
                        if (finished) {
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            return;
                        }
                        long prevIterPos = nextIterPos;
                        lastValues = SetReactiveIterator.this.convert(res.getValues());
                        client = res.getRedisClient();
                        if (nextIterPos == 0L && firstValues == null) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty()) {
                                client = null;
                                firstValues = null;
                                nextIterPos = 0L;
                                prevIterPos = -1L;
                            }
                        } else if (firstValues.isEmpty()) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty() && res.getPos() == 0L) {
                                finished = true;
                                m.onComplete();
                                return;
                            }
                        } else if (lastValues.removeAll(firstValues)) {
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            prevIterPos = -1L;
                            finished = true;
                            m.onComplete();
                            return;
                        }
                        this.handle(res.getValues());
                        nextIterPos = res.getPos();
                        if (prevIterPos == nextIterPos) {
                            finished = true;
                            m.onComplete();
                        }
                    }

                    @Override
                    public void onError(Throwable error) {
                        m.onError(error);
                    }

                    @Override
                    public void onComplete() {
                        if (finished) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    private List<HashValue> convert(List<ScanObjectEntry> list) {
        ArrayList<HashValue> result = new ArrayList<HashValue>(list.size());
        for (ScanObjectEntry entry : list) {
            result.add(entry.getHash());
        }
        return result;
    }

    protected abstract Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient var1, long var2);
}

