/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.regex.Pattern;

public class URIBuilder {
    private static final Pattern ipv4Pattern = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])", 2);
    private static final Pattern ipv6Pattern = Pattern.compile("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}", 2);

    public static URI create(String uri) {
        URI u = URI.create(uri);
        if (u.getHost() != null) {
            return u;
        }
        String s = uri.substring(0, uri.lastIndexOf(":")).replaceFirst("redis://", "").replaceFirst("rediss://", "");
        return URI.create(uri.replace(s, "[" + s + "]"));
    }

    public static boolean isValidIP(String host) {
        if (ipv4Pattern.matcher(host).matches()) {
            return true;
        }
        return ipv6Pattern.matcher(host).matches();
    }

    public static boolean compare(InetSocketAddress entryAddr, URI addr) {
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(addr.getHost()) || entryAddr.getAddress().getHostAddress().equals(addr.getHost())) && entryAddr.getPort() == addr.getPort();
    }
}

