/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import org.redisson.config.BaseConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;

public class BaseMasterSlaveServersConfig<T extends BaseMasterSlaveServersConfig<T>>
extends BaseConfig<T> {
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private int slaveConnectionMinimumIdleSize = 32;
    private int slaveConnectionPoolSize = 64;
    private int failedSlaveReconnectionInterval = 3000;
    private int failedSlaveCheckInterval = 60000;
    private int masterConnectionMinimumIdleSize = 32;
    private int masterConnectionPoolSize = 64;
    private ReadMode readMode = ReadMode.SLAVE;
    private SubscriptionMode subscriptionMode = SubscriptionMode.SLAVE;
    private int subscriptionConnectionMinimumIdleSize = 1;
    private int subscriptionConnectionPoolSize = 50;
    private long dnsMonitoringInterval = 5000L;

    public BaseMasterSlaveServersConfig() {
    }

    BaseMasterSlaveServersConfig(T config) {
        super(config);
        this.setLoadBalancer(((BaseMasterSlaveServersConfig)config).getLoadBalancer());
        this.setMasterConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getMasterConnectionPoolSize());
        this.setSlaveConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSlaveConnectionPoolSize());
        this.setSubscriptionConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSubscriptionConnectionPoolSize());
        this.setMasterConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getMasterConnectionMinimumIdleSize());
        this.setSlaveConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getSlaveConnectionMinimumIdleSize());
        this.setSubscriptionConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getSubscriptionConnectionMinimumIdleSize());
        this.setReadMode(((BaseMasterSlaveServersConfig)config).getReadMode());
        this.setSubscriptionMode(((BaseMasterSlaveServersConfig)config).getSubscriptionMode());
        this.setDnsMonitoringInterval(((BaseMasterSlaveServersConfig)config).getDnsMonitoringInterval());
        this.setFailedSlaveCheckInterval(((BaseMasterSlaveServersConfig)config).getFailedSlaveCheckInterval());
        this.setFailedSlaveReconnectionInterval(((BaseMasterSlaveServersConfig)config).getFailedSlaveReconnectionInterval());
    }

    public T setSlaveConnectionPoolSize(int slaveConnectionPoolSize) {
        this.slaveConnectionPoolSize = slaveConnectionPoolSize;
        return (T)this;
    }

    public int getSlaveConnectionPoolSize() {
        return this.slaveConnectionPoolSize;
    }

    public T setFailedSlaveReconnectionInterval(int failedSlavesReconnectionTimeout) {
        this.failedSlaveReconnectionInterval = failedSlavesReconnectionTimeout;
        return (T)this;
    }

    public int getFailedSlaveReconnectionInterval() {
        return this.failedSlaveReconnectionInterval;
    }

    public T setFailedSlaveCheckInterval(int slaveFailsInterval) {
        this.failedSlaveCheckInterval = slaveFailsInterval;
        return (T)this;
    }

    public int getFailedSlaveCheckInterval() {
        return this.failedSlaveCheckInterval;
    }

    public T setMasterConnectionPoolSize(int masterConnectionPoolSize) {
        this.masterConnectionPoolSize = masterConnectionPoolSize;
        return (T)this;
    }

    public int getMasterConnectionPoolSize() {
        return this.masterConnectionPoolSize;
    }

    public T setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (T)this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    @Deprecated
    public T setSlaveSubscriptionConnectionPoolSize(int slaveSubscriptionConnectionPoolSize) {
        return this.setSubscriptionConnectionPoolSize(slaveSubscriptionConnectionPoolSize);
    }

    @Deprecated
    public int getSlaveSubscriptionConnectionPoolSize() {
        return this.getSubscriptionConnectionPoolSize();
    }

    public T setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
        this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
        return (T)this;
    }

    public int getSubscriptionConnectionPoolSize() {
        return this.subscriptionConnectionPoolSize;
    }

    public T setSlaveConnectionMinimumIdleSize(int slaveConnectionMinimumIdleSize) {
        this.slaveConnectionMinimumIdleSize = slaveConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getSlaveConnectionMinimumIdleSize() {
        return this.slaveConnectionMinimumIdleSize;
    }

    public T setMasterConnectionMinimumIdleSize(int masterConnectionMinimumIdleSize) {
        this.masterConnectionMinimumIdleSize = masterConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getMasterConnectionMinimumIdleSize() {
        return this.masterConnectionMinimumIdleSize;
    }

    @Deprecated
    public T setSlaveSubscriptionConnectionMinimumIdleSize(int slaveSubscriptionConnectionMinimumIdleSize) {
        return this.setSubscriptionConnectionMinimumIdleSize(slaveSubscriptionConnectionMinimumIdleSize);
    }

    @Deprecated
    public int getSlaveSubscriptionConnectionMinimumIdleSize() {
        return this.getSubscriptionConnectionMinimumIdleSize();
    }

    public T setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
        this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getSubscriptionConnectionMinimumIdleSize() {
        return this.subscriptionConnectionMinimumIdleSize;
    }

    public T setReadMode(ReadMode readMode) {
        this.readMode = readMode;
        return (T)this;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }

    public boolean checkSkipSlavesInit() {
        return this.getReadMode() == ReadMode.MASTER && this.getSubscriptionMode() == SubscriptionMode.MASTER;
    }

    public T setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
        return (T)this;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public T setDnsMonitoringInterval(long dnsMonitoringInterval) {
        this.dnsMonitoringInterval = dnsMonitoringInterval;
        return (T)this;
    }

    public long getDnsMonitoringInterval() {
        return this.dnsMonitoringInterval;
    }
}

