/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import org.reactivestreams.Subscriber;
import org.redisson.api.RFuture;
import reactor.core.support.Exceptions;
import reactor.fn.Supplier;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class NettyFuturePublisher<T>
extends Stream<T> {
    private final Supplier<RFuture<T>> supplier;

    public NettyFuturePublisher(Supplier<RFuture<T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new ReactiveSubscription<T>(this, subscriber){

                @Override
                protected void onRequest(long n) {
                    ((RFuture)NettyFuturePublisher.this.supplier.get()).addListener(new FutureListener<T>(){

                        @Override
                        public void operationComplete(Future<T> future) throws Exception {
                            if (!future.isSuccess()) {
                                this.onError(future.cause());
                                return;
                            }
                            if (future.getNow() != null) {
                                this.onNext(future.getNow());
                            }
                            this.onComplete();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            subscriber.onError(throwable);
        }
    }
}

