/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.misc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.redisson.api.RObject;

public class ClassUtils {
    public static void setField(Object obj, String fieldName, Object value) {
        try {
            Field field = ClassUtils.getDeclaredField(obj.getClass(), fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        try {
            Field field = ClassUtils.getDeclaredField(clazz, fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.getAnnotation(annotationClass);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
            if (c.getAnnotation(annotationClass) == null) continue;
            return c.getAnnotation(annotationClass);
        }
        return null;
    }

    public static <T> T getField(Object obj, String fieldName) {
        try {
            Field field = ClassUtils.getDeclaredField(obj.getClass(), fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        for (Class<?> c : ClassUtils.getClassHierarchy(clazz)) {
            if (!c.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<Class<?>> getClassHierarchy(Class<?> clazz) {
        if (Arrays.asList(clazz.getInterfaces()).contains(RObject.class)) {
            return Collections.singleton(clazz);
        }
        ArrayList classes = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            classes.add(c);
        }
        return classes;
    }

    public static Method searchForMethod(Class<?> type, String name, Class<?>[] parms) {
        try {
            return type.getMethod(name, parms);
        }
        catch (NoSuchMethodException e) {
            Method[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] types;
                if (!methods[i].getName().equals(name) || (types = methods[i].getParameterTypes()).length != parms.length || !ClassUtils.areTypesCompatible(types, parms)) continue;
                return methods[i];
            }
            return null;
        }
    }

    private static boolean areTypesCompatible(Class<?>[] targets, Class<?>[] sources) {
        if (targets.length != sources.length) {
            return false;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (sources[i] == null || ClassUtils.translateFromPrimitive(targets[i]).isAssignableFrom(sources[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> translateFromPrimitive(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + primitive);
    }
}

