/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription.support;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public class WrappedSubscription<O>
extends PushSubscription<O> {
    protected final Subscription subscription;
    protected final PushSubscription<O> pushSubscription;

    public WrappedSubscription(Subscription subscription, Subscriber<? super O> subscriber) {
        super(null, subscriber);
        this.subscription = subscription;
        this.pushSubscription = PushSubscription.class.isAssignableFrom(subscription.getClass()) ? (PushSubscription)subscription : null;
    }

    @Override
    public void request(long n) {
        if (this.pushSubscription != null) {
            this.pushSubscription.request(n);
        } else {
            super.request(n);
        }
    }

    @Override
    public void cancel() {
        this.subscription.cancel();
        super.cancel();
    }

    @Override
    public final Stream<O> getPublisher() {
        return PushSubscription.class.isAssignableFrom(this.subscription.getClass()) ? ((PushSubscription)this.subscription).getPublisher() : null;
    }

    @Override
    public void maxCapacity(long n) {
        if (this.pushSubscription != null) {
            this.pushSubscription.maxCapacity(n);
        }
    }

    @Override
    public void updatePendingRequests(long n) {
        if (this.pushSubscription != null) {
            this.pushSubscription.updatePendingRequests(n);
        } else {
            super.updatePendingRequests(n);
        }
    }

    @Override
    public boolean shouldRequestPendingSignals() {
        if (this.pushSubscription != null) {
            return this.pushSubscription.shouldRequestPendingSignals();
        }
        return super.shouldRequestPendingSignals();
    }

    @Override
    public boolean isComplete() {
        if (this.pushSubscription != null) {
            return this.pushSubscription.isComplete();
        }
        return super.isComplete();
    }

    @Override
    protected final void onRequest(long elements) {
        this.subscription.request(elements);
    }

    @Override
    public final boolean equals(Object o) {
        return o != null && this.subscription.getClass() == o.getClass() && this.subscription.equals(o);
    }

    @Override
    public final boolean hasPublisher() {
        return this.subscription != null;
    }

    @Override
    public final int hashCode() {
        return this.subscription.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " wrapped=" + this.subscription;
    }
}

