/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.Redisson;
import org.redisson.RedissonList;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPriorityQueue;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RedissonPromise;

public class RedissonPriorityQueue<V>
extends RedissonList<V>
implements RPriorityQueue<V> {
    private Comparator<? super V> comparator = NaturalComparator.NATURAL_ORDER;
    CommandExecutor commandExecutor;
    RLock lock;
    private RBucket<String> comparatorHolder;

    protected RedissonPriorityQueue(CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
        this.comparatorHolder = redisson.getBucket(this.getComparatorKeyName(), StringCodec.INSTANCE);
        this.lock = redisson.getLock("redisson_sortedset_lock:{" + this.getName() + "}");
        this.loadComparator();
    }

    public RedissonPriorityQueue(Codec codec, CommandExecutor commandExecutor, String name, Redisson redisson) {
        super(codec, commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
        this.comparatorHolder = redisson.getBucket(this.getComparatorKeyName(), StringCodec.INSTANCE);
        this.lock = redisson.getLock("redisson_sortedset_lock:{" + this.getName() + "}");
        this.loadComparator();
    }

    private void loadComparator() {
        try {
            String comparatorSign = this.comparatorHolder.get();
            if (comparatorSign != null) {
                String[] parts = comparatorSign.split(":");
                String className = parts[0];
                String sign = parts[1];
                String result = RedissonPriorityQueue.calcClassSign(className);
                if (!result.equals(sign)) {
                    throw new IllegalStateException("Local class signature of " + className + " differs from used by this SortedSet!");
                }
                Class<?> clazz = Class.forName(className);
                this.comparator = (Comparator)clazz.newInstance();
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String calcClassSign(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(result);
            outputStream.writeObject(clazz);
            outputStream.close();
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(result.toByteArray());
            return new BigInteger(1, crypt.digest()).toString(16);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't calculate sign of " + name, e);
        }
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.LRANGE, this.getName(), 0, -1);
    }

    @Override
    public boolean offer(V e) {
        return this.add(e);
    }

    public RFuture<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public boolean contains(Object o) {
        return this.binarySearch(o, this.codec).getIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<V> res = this.binarySearch(value, this.codec);
            int index = 0;
            index = res.getIndex() < 0 ? -(res.getIndex() + 1) : res.getIndex() + 1;
            byte[] encodedValue = this.encode(value);
            this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_VOID, "local len = redis.call('llen', KEYS[1]);if tonumber(ARGV[1]) < len then local pivot = redis.call('lindex', KEYS[1], ARGV[1]);redis.call('linsert', KEYS[1], 'before', pivot, ARGV[2]);return;end;redis.call('rpush', KEYS[1], ARGV[2]);", Arrays.asList(this.getName()), index, encodedValue);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkComparator() {
        String comparatorSign = this.comparatorHolder.get();
        if (comparatorSign != null) {
            String[] vals = comparatorSign.split(":");
            String className = vals[0];
            if (!this.comparator.getClass().getName().equals(className)) {
                this.loadComparator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        this.lock.lock();
        try {
            this.checkComparator();
            BinarySearchResult<Object> res = this.binarySearch(value, this.codec);
            if (res.getIndex() < 0) {
                boolean bl = false;
                return bl;
            }
            this.remove(res.getIndex());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (c.contains(object)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    public RFuture<V> pollAsync() {
        final long threadId = Thread.currentThread().getId();
        final RedissonPromise result = new RedissonPromise();
        this.lock.lockAsync(threadId).addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RFuture f = RedissonPriorityQueue.this.commandExecutor.writeAsync(RedissonPriorityQueue.this.getName(), RedissonPriorityQueue.this.codec, RedisCommands.LPOP, RedissonPriorityQueue.this.getName());
                f.addListener(new FutureListener<V>(){

                    @Override
                    public void operationComplete(Future<V> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        final Object value = future.getNow();
                        RedissonPriorityQueue.this.lock.unlockAsync(threadId).addListener(new FutureListener<Void>(){

                            @Override
                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    result.tryFailure(future.cause());
                                    return;
                                }
                                result.trySuccess(value);
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    @Override
    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    public RFuture<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    private String getComparatorKeyName() {
        return "redisson_sortedset_comparator:{" + this.getName() + "}";
    }

    @Override
    public boolean trySetComparator(Comparator<? super V> comparator) {
        String className = comparator.getClass().getName();
        String comparatorSign = className + ":" + RedissonPriorityQueue.calcClassSign(className);
        Boolean res = (Boolean)this.commandExecutor.evalWrite(this.getName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('llen', KEYS[1]) == 0 then redis.call('set', KEYS[2], ARGV[1]); return 1; else return 0; end", Arrays.asList(this.getName(), this.getComparatorKeyName()), comparatorSign);
        if (res.booleanValue()) {
            this.comparator = comparator;
        }
        return res;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    public BinarySearchResult<V> binarySearch(V value, Codec codec) {
        int size = this.size();
        int upperIndex = size - 1;
        int lowerIndex = 0;
        while (lowerIndex <= upperIndex) {
            int index = lowerIndex + (upperIndex - lowerIndex) / 2;
            Object res = this.getValue(index);
            if (res == null) {
                return new BinarySearchResult();
            }
            int cmp = this.comparator.compare(value, res);
            if (cmp == 0) {
                BinarySearchResult indexRes = new BinarySearchResult();
                indexRes.setIndex(index);
                return indexRes;
            }
            if (cmp < 0) {
                upperIndex = index - 1;
                continue;
            }
            lowerIndex = index + 1;
        }
        BinarySearchResult indexRes = new BinarySearchResult();
        indexRes.setIndex(-(lowerIndex + 1));
        return indexRes;
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static class BinarySearchResult<V> {
        private V value;
        private Integer index;

        public BinarySearchResult(V value) {
            this.value = value;
        }

        public BinarySearchResult() {
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static class NaturalComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final NaturalComparator NATURAL_ORDER = new NaturalComparator();

        private NaturalComparator() {
        }

        @Override
        public int compare(V c1, V c2) {
            Comparable c1co = (Comparable)c1;
            Comparable c2co = (Comparable)c2;
            return c1co.compareTo(c2co);
        }
    }
}

