/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.redisson.RedissonClient;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.client.codec.Codec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonCache;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class RedissonSpringCacheManager
implements CacheManager,
ResourceLoaderAware,
InitializingBean {
    private ResourceLoader resourceLoader;
    private Codec codec;
    private RedissonClient redisson;
    private Map<String, CacheConfig> configMap = new HashMap<String, CacheConfig>();
    private String configLocation;

    public RedissonSpringCacheManager() {
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config) {
        this(redisson, config, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, Map<String, CacheConfig> config, Codec codec) {
        this.redisson = redisson;
        this.configMap = config;
        this.codec = codec;
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null);
    }

    public RedissonSpringCacheManager(RedissonClient redisson, String configLocation, Codec codec) {
        this.redisson = redisson;
        this.configLocation = configLocation;
        this.codec = codec;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfig(Map<String, CacheConfig> config) {
        this.configMap = config;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public Cache getCache(String name) {
        CacheConfig config = this.configMap.get(name);
        if (config == null) {
            config = new CacheConfig();
            this.configMap.put(name, config);
            RMap<Object, Object> map = this.createMap(name);
            return new RedissonCache(this.redisson, map);
        }
        if (config.getMaxIdleTime() == 0L && config.getTTL() == 0L) {
            RMap<Object, Object> map = this.createMap(name);
            return new RedissonCache(this.redisson, map);
        }
        RMapCache<Object, Object> map = this.createMapCache(name);
        return new RedissonCache(this.redisson, map, config);
    }

    private RMap<Object, Object> createMap(String name) {
        if (this.codec != null) {
            return this.redisson.getMap(name, this.codec);
        }
        return this.redisson.getMap(name);
    }

    private RMapCache<Object, Object> createMapCache(String name) {
        if (this.codec != null) {
            return this.redisson.getMapCache(name, this.codec);
        }
        return this.redisson.getMapCache(name);
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.configMap.keySet());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configLocation == null) {
            return;
        }
        Resource resource = this.resourceLoader.getResource(this.configLocation);
        try {
            this.configMap = CacheConfig.fromJSON(resource.getInputStream());
        }
        catch (IOException e) {
            try {
                this.configMap = CacheConfig.fromYAML(resource.getInputStream());
            }
            catch (IOException e1) {
                throw new BeanDefinitionStoreException("Could not parse cache configuration at [" + this.configLocation + "]", (Throwable)e1);
            }
        }
    }
}

