/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.redisson.RedissonClient;
import org.redisson.api.annotation.RInject;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.ClassLoaderDelegator;
import org.redisson.executor.RedissonClassLoader;
import org.redisson.executor.RemoteExecutorService;

public class RemoteExecutorServiceImpl
implements RemoteExecutorService {
    private final ClassLoaderDelegator classLoader = new ClassLoaderDelegator();
    private final Codec codec;
    private final String name;
    private final CommandExecutor commandExecutor;
    private final RedissonClient redisson;
    private String tasksCounterName;
    private String statusName;
    private String topicName;

    public RemoteExecutorServiceImpl(CommandExecutor commandExecutor, RedissonClient redisson, Codec codec, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.redisson = redisson;
        try {
            this.codec = (Codec)codec.getClass().getConstructor(ClassLoader.class).newInstance(this.classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Override
    public Object execute(String className, byte[] classBody, byte[] state) {
        ByteBuf buf = null;
        try {
            buf = Unpooled.wrappedBuffer(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.getClass().getClassLoader());
            cl.loadClass(className, classBody);
            this.classLoader.setCurrentClassLoader(cl);
            Callable callable = (Callable)this.decode(buf);
            Object v = callable.call();
            return v;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish();
        }
    }

    private <T> T decode(ByteBuf buf) throws IOException {
        Field[] fields;
        Object task = this.codec.getValueDecoder().decode(buf, null);
        for (Field field : fields = task.getClass().getDeclaredFields()) {
            if (!RedissonClient.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(RInject.class)) continue;
            field.setAccessible(true);
            try {
                field.set(task, this.redisson);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return (T)task;
    }

    @Override
    public void executeVoid(String className, byte[] classBody, byte[] state) {
        ByteBuf buf = null;
        try {
            buf = Unpooled.wrappedBuffer(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.getClass().getClassLoader());
            cl.loadClass(className, classBody);
            this.classLoader.setCurrentClassLoader(cl);
            Runnable runnable = (Runnable)this.decode(buf);
            runnable.run();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish();
        }
    }

    private void finish() {
        this.classLoader.clearCurrentClassLoader();
        this.commandExecutor.evalWrite(this.name, this.codec, RedisCommands.EVAL_VOID_WITH_VALUES_6, "if redis.call('decr', KEYS[1]) == 0 and redis.call('get', KEYS[2]) == ARGV[1] then redis.call('set', KEYS[2], ARGV[2]);redis.call('publish', KEYS[3], ARGV[2]);end;", Arrays.asList(this.tasksCounterName, this.statusName, this.topicName), 1, 2);
    }
}

