/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Arrays;
import org.redisson.Redisson;
import org.redisson.RedissonRemoteService;
import org.redisson.api.RBlockingQueue;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.remote.RemoteServiceRequest;

public class ExecutorRemoteService
extends RedissonRemoteService {
    private String tasksCounterName;
    private String statusName;

    public ExecutorRemoteService(Codec codec, Redisson redisson, String name, CommandExecutor commandExecutor) {
        super(codec, redisson, name, commandExecutor);
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    @Override
    protected Future<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request, RemotePromise<Object> result) {
        final Promise<Boolean> promise = this.commandExecutor.getConnectionManager().newPromise();
        Future<Boolean> future = this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('rpush', KEYS[3], ARGV[1]); redis.call('incr', KEYS[1]);return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, requestQueue.getName()), new Object[]{this.encode(request)});
        result.setAddFuture(future);
        future.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.setFailure(future.cause());
                    return;
                }
                if (!future.getNow().booleanValue()) {
                    promise.cancel(true);
                    return;
                }
                promise.setSuccess(true);
            }
        });
        return promise;
    }
}

