/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Map;
import org.redisson.api.ClusterNode;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionManager;

public class RedisClientEntry
implements ClusterNode {
    private final RedisClient client;
    private final ConnectionManager manager;
    private final NodeType type;

    public RedisClientEntry(RedisClient client, ConnectionManager manager, NodeType type) {
        this.client = client;
        this.manager = manager;
        this.type = type;
    }

    @Override
    public NodeType getType() {
        return this.type;
    }

    public RedisClient getClient() {
        return this.client;
    }

    @Override
    public InetSocketAddress getAddr() {
        return this.client.getAddr();
    }

    private RedisConnection connect() {
        RedisConnection c = this.client.connect();
        Promise future = this.manager.newPromise();
        this.manager.getConnectListener().onConnect(future, c, null, this.manager.getConfig());
        future.syncUninterruptibly();
        return (RedisConnection)future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping() {
        RedisConnection c = null;
        try {
            c = this.connect();
            boolean bl = "PONG".equals(c.sync(RedisCommands.PING, new Object[0]));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                c.closeAsync();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getAddr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisClientEntry other = (RedisClientEntry)obj;
        return !(this.client == null ? other.client != null : !this.client.getAddr().equals(other.client.getAddr()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> info() {
        RedisConnection c = null;
        try {
            c = this.connect();
            Map<String, String> map = c.sync(RedisCommands.CLUSTER_INFO, new Object[0]);
            return map;
        }
        catch (Exception e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (c != null) {
                c.closeAsync();
            }
        }
    }
}

