/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.AsyncDetails;
import org.redisson.command.CommandReactiveService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;

public class CommandBatchService
extends CommandReactiveService {
    private final AtomicInteger index = new AtomicInteger();
    private ConcurrentMap<MasterSlaveEntry, Entry> commands = PlatformDependent.newConcurrentHashMap();
    private volatile boolean executed;

    public CommandBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, Promise<R> mainPromise, int attempt) {
        if (this.executed) {
            throw new IllegalStateException("Batch already has been executed!");
        }
        Entry entry = (Entry)this.commands.get(nodeSource.getEntry());
        if (entry == null) {
            entry = new Entry();
            Entry oldEntry = this.commands.putIfAbsent(nodeSource.getEntry(), entry);
            if (oldEntry != null) {
                entry = oldEntry;
            }
        }
        if (!readOnlyMode) {
            entry.setReadOnlyMode(false);
        }
        BatchCommandData<V, R> commandData = new BatchCommandData<V, R>(mainPromise, codec, command, params, this.index.incrementAndGet());
        entry.getCommands().add(commandData);
    }

    public List<?> execute() {
        return this.get(this.executeAsync());
    }

    public Future<Void> executeAsyncVoid() {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return this.connectionManager.newSucceededFuture(null);
        }
        this.executed = true;
        Promise<Void> voidPromise = this.connectionManager.newPromise();
        voidPromise.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                CommandBatchService.this.commands = null;
            }
        });
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), new NodeSource((MasterSlaveEntry)e.getKey()), voidPromise, slots, 0);
        }
        return voidPromise;
    }

    public Future<List<?>> executeAsync() {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return this.connectionManager.newSucceededFuture(null);
        }
        this.executed = true;
        Promise<Void> voidPromise = this.connectionManager.newPromise();
        final Promise<List<?>> promise = this.connectionManager.newPromise();
        voidPromise.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.setFailure(future.cause());
                    CommandBatchService.this.commands = null;
                    return;
                }
                ArrayList entries = new ArrayList();
                for (Entry e : CommandBatchService.this.commands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList result = new ArrayList(entries.size());
                for (BatchCommandData batchCommandData : entries) {
                    result.add(batchCommandData.getPromise().getNow());
                }
                promise.setSuccess(result);
                CommandBatchService.this.commands = null;
            }
        });
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), new NodeSource((MasterSlaveEntry)e.getKey()), voidPromise, slots, 0);
        }
        return promise;
    }

    public void execute(final Entry entry, final NodeSource source, final Promise<Void> mainPromise, final AtomicInteger slots, final int attempt) {
        if (mainPromise.isCancelled()) {
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            mainPromise.setFailure(new IllegalStateException("Redisson is shutdown"));
            return;
        }
        final Promise<Void> attemptPromise = this.connectionManager.newPromise();
        final AsyncDetails details = new AsyncDetails();
        final Future<RedisConnection> connectionFuture = entry.isReadOnlyMode() ? this.connectionManager.connectionReadOp(source, null) : this.connectionManager.connectionWriteOp(source, null);
        TimerTask retryTimerTask = new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                ChannelFuture writeFuture;
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    CommandBatchService.this.connectionManager.getShutdownLatch().release();
                } else if (connectionFuture.isSuccess() && (writeFuture = details.getWriteFuture()) != null && !writeFuture.cancel(false) && writeFuture.isSuccess()) {
                    return;
                }
                if (mainPromise.isCancelled()) {
                    attemptPromise.cancel(false);
                    return;
                }
                if (attempt == CommandBatchService.this.connectionManager.getConfig().getRetryAttempts()) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Batch command execution timeout"));
                    }
                    attemptPromise.tryFailure(details.getException());
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                int count = attempt + 1;
                CommandBatchService.this.execute(entry, source, mainPromise, slots, count);
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        if (connectionFuture.isDone()) {
            this.checkConnectionFuture(entry, source, mainPromise, attemptPromise, details, connectionFuture);
        } else {
            connectionFuture.addListener((GenericFutureListener<Future<RedisConnection>>)new FutureListener<RedisConnection>(){

                @Override
                public void operationComplete(Future<RedisConnection> connFuture) throws Exception {
                    CommandBatchService.this.checkConnectionFuture(entry, source, mainPromise, attemptPromise, details, connFuture);
                }
            });
        }
        attemptPromise.addListener((GenericFutureListener<Future<Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                details.getTimeout().cancel();
                if (future.isCancelled()) {
                    return;
                }
                if (future.cause() instanceof RedisMovedException) {
                    RedisMovedException ex = (RedisMovedException)future.cause();
                    entry.clearErrors();
                    CommandBatchService.this.execute(entry, new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.MOVED), mainPromise, slots, attempt);
                    return;
                }
                if (future.cause() instanceof RedisAskException) {
                    RedisAskException ex = (RedisAskException)future.cause();
                    entry.clearErrors();
                    CommandBatchService.this.execute(entry, new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.ASK), mainPromise, slots, attempt);
                    return;
                }
                if (future.cause() instanceof RedisLoadingException) {
                    entry.clearErrors();
                    CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt);
                    return;
                }
                if (future.isSuccess()) {
                    if (slots.decrementAndGet() == 0) {
                        mainPromise.setSuccess(future.getNow());
                    }
                } else {
                    mainPromise.setFailure(future.cause());
                }
            }
        });
    }

    private void checkWriteFuture(final Promise<Void> attemptPromise, AsyncDetails details, final RedisConnection connection, ChannelFuture future) {
        if (attemptPromise.isDone() || future.isCancelled()) {
            return;
        }
        if (!future.isSuccess()) {
            details.setException(new WriteRedisConnectionException("Can't write command batch to channel: " + future.channel(), future.cause()));
        } else {
            details.getTimeout().cancel();
            TimerTask timeoutTask = new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    attemptPromise.tryFailure(new RedisTimeoutException("Redis server response timeout during command batch execution. Channel: " + connection.getChannel()));
                }
            };
            Timeout timeout = this.connectionManager.newTimeout(timeoutTask, this.connectionManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
            details.setTimeout(timeout);
        }
    }

    private void checkConnectionFuture(Entry entry, NodeSource source, Promise<Void> mainPromise, final Promise<Void> attemptPromise, final AsyncDetails details, Future<RedisConnection> connFuture) {
        if (attemptPromise.isDone() || mainPromise.isCancelled() || connFuture.isCancelled()) {
            return;
        }
        if (!connFuture.isSuccess()) {
            this.connectionManager.getShutdownLatch().release();
            details.setException(this.convertException(connFuture));
            return;
        }
        final RedisConnection connection = connFuture.getNow();
        ArrayList list = new ArrayList(entry.getCommands().size() + 1);
        if (source.getRedirect() == NodeSource.Redirect.ASK) {
            Promise promise = this.connectionManager.newPromise();
            list.add(new CommandData(promise, StringCodec.INSTANCE, RedisCommands.ASKING, new Object[0]));
        }
        for (BatchCommandData<?, ?> c : entry.getCommands()) {
            if (c.getPromise().isSuccess()) continue;
            list.add(c);
        }
        ChannelFuture future = connection.send(new CommandsData(attemptPromise, list));
        details.setWriteFuture(future);
        if (details.getWriteFuture().isDone()) {
            this.checkWriteFuture(attemptPromise, details, connection, details.getWriteFuture());
        } else {
            details.getWriteFuture().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    CommandBatchService.this.checkWriteFuture(attemptPromise, details, connection, future);
                }
            });
        }
        this.releaseConnection(source, connFuture, entry.isReadOnlyMode(), attemptPromise, details);
    }

    public static class Entry {
        Collection<BatchCommandData<?, ?>> commands = new ConcurrentLinkedQueue();
        volatile boolean readOnlyMode = true;

        public Collection<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }
}

