/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import io.netty.util.concurrent.Promise;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class CommandData<T, R>
implements QueueCommand {
    final Promise<R> promise;
    final RedisCommand<T> command;
    final Object[] params;
    final Codec codec;
    final MultiDecoder<Object> messageDecoder;

    public CommandData(Promise<R> promise, Codec codec, RedisCommand<T> command, Object[] params) {
        this(promise, null, codec, command, params);
    }

    public CommandData(Promise<R> promise, MultiDecoder<Object> messageDecoder, Codec codec, RedisCommand<T> command, Object[] params) {
        this.promise = promise;
        this.command = command;
        this.params = params;
        this.codec = codec;
        this.messageDecoder = messageDecoder;
    }

    public RedisCommand<T> getCommand() {
        return this.command;
    }

    public Object[] getParams() {
        return this.params;
    }

    public MultiDecoder<Object> getMessageDecoder() {
        return this.messageDecoder;
    }

    public Promise<R> getPromise() {
        return this.promise;
    }

    public Throwable cause() {
        return this.promise.cause();
    }

    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    public boolean tryFailure(Throwable cause) {
        return this.promise.tryFailure(cause);
    }

    public Codec getCodec() {
        return this.codec;
    }

    public String toString() {
        return "CommandData [promise=" + this.promise + ", command=" + this.command + ", params=" + Arrays.toString(this.params) + ", codec=" + this.codec + "]";
    }

    @Override
    public List<CommandData<Object, Object>> getPubSubOperations() {
        if (PUBSUB_COMMANDS.contains(this.getCommand().getName())) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    public boolean isBlockingCommand() {
        return QueueCommand.TIMEOUTLESS_COMMANDS.contains(this.command.getName()) && !this.promise.isDone();
    }
}

